/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.typehierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.IIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraphEdge;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraphNode;
import org.eclipse.ptp.rdt.core.RDTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class THGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ICElement[] NO_MEMBERS = new ICElement[0];
    private THGraphNode fInputNode = null;
    private HashSet<THGraphNode> fRootNodes = new HashSet();
    private HashSet<THGraphNode> fLeaveNodes = new HashSet();
    private HashMap<ICElement, THGraphNode> fNodes = new HashMap();
    private boolean fFileIsIndexed;
    private transient IIndexLocationConverterFactory fConverterFactory;

    public THGraphNode getInputNode() {
        return this.fInputNode;
    }

    public THGraphNode getNode(ICElement elem) {
        return this.fNodes.get(elem);
    }

    public void setLocationConverterFactory(IIndexLocationConverterFactory converter) {
        this.fConverterFactory = converter;
    }

    private THGraphNode addNode(ICElement input, String path) {
        THGraphNode node = this.fNodes.get(input);
        if (node == null) {
            node = new THGraphNode(input, path);
            this.fNodes.put(input, node);
            this.fRootNodes.add(node);
            this.fLeaveNodes.add(node);
        }
        return node;
    }

    private THGraphEdge addEdge(THGraphNode from, THGraphNode to) {
        if (this.createsLoopOrIsDuplicate(from, to)) {
            return null;
        }
        THGraphEdge edge = new THGraphEdge(from, to);
        from.startEdge(edge);
        to.endEdge(edge);
        this.fRootNodes.remove(to);
        this.fLeaveNodes.remove(from);
        return edge;
    }

    private boolean createsLoopOrIsDuplicate(THGraphNode from, THGraphNode to) {
        if (from == to) {
            return true;
        }
        if (to.getOutgoing().isEmpty() || from.getIncoming().isEmpty()) {
            return false;
        }
        HashSet<THGraphNode> checked = new HashSet<THGraphNode>();
        ArrayList<THGraphNode> stack = new ArrayList<THGraphNode>();
        stack.add(to);
        while (!stack.isEmpty()) {
            THGraphNode node = (THGraphNode)stack.remove(stack.size() - 1);
            List<THGraphEdge> out = node.getOutgoing();
            for (THGraphEdge edge : out) {
                node = edge.getEndNode();
                if (node == from) {
                    return true;
                }
                if (!checked.add(node)) continue;
                stack.add(node);
            }
        }
        List<THGraphEdge> out = from.getOutgoing();
        for (THGraphEdge edge : out) {
            if (edge.getEndNode() != to) continue;
            return true;
        }
        return false;
    }

    public Collection<THGraphNode> getRootNodes() {
        return this.fRootNodes;
    }

    public Collection<THGraphNode> getLeaveNodes() {
        return this.fLeaveNodes;
    }

    public void defineInputNode(IIndex index, ICElement input, ICProjectFactory projectFactory, String path) {
        if (input != null) {
            try {
                this.fFileIsIndexed = true;
                input = IndexQueries.attemptConvertionToHandle(index, input, this.fConverterFactory, projectFactory);
                this.fInputNode = this.addNode(input, path);
            }
            catch (CoreException e) {
                RDTLog.logError(e);
            }
        }
    }

    public void addSuperClasses(IIndex index, IProgressMonitor monitor, ICProjectFactory projectFactory) {
        if (this.fInputNode == null) {
            return;
        }
        HashSet<StackElement> handled = new HashSet<StackElement>();
        ArrayList<StackElement> stack = new ArrayList<StackElement>();
        StackElement stackElement = new StackElement(this.fInputNode.getElement(), this.fInputNode.getPath());
        stack.add(stackElement);
        handled.add(stackElement);
        while (!stack.isEmpty()) {
            if (monitor.isCanceled()) {
                return;
            }
            StackElement se = (StackElement)stack.remove(stack.size() - 1);
            THGraphNode graphNode = this.addNode(se.fElement, se.fPath);
            try {
                IType type;
                ICPPClassType ct;
                IIndexBinding binding = IndexQueries.elementToBinding(index, se.fElement, se.fPath);
                if (binding != null) {
                    this.addMembers(index, graphNode, (IBinding)binding, projectFactory);
                }
                if (binding instanceof ICPPClassType) {
                    ct = (ICPPClassType)binding;
                    ICPPBase[] bases = ct.getBases();
                    int i = 0;
                    while (i < bases.length) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        ICPPBase base = bases[i];
                        IName name = base.getBaseClassSpecifierName();
                        IBinding basecl = name != null ? index.findBinding(name) : base.getBaseClass();
                        ICElement[] baseElems = IndexQueries.findRepresentative(index, basecl, this.fConverterFactory, null, projectFactory);
                        String[] paths = IndexQueries.findRepresentitivePaths(index, basecl, this.fConverterFactory, null, projectFactory);
                        int j = 0;
                        while (j < baseElems.length) {
                            ICElement baseElem = baseElems[j];
                            String path = paths[j];
                            THGraphNode baseGraphNode = this.addNode(baseElem, path);
                            this.addMembers(index, baseGraphNode, basecl, projectFactory);
                            this.addEdge(graphNode, baseGraphNode);
                            StackElement se1 = new StackElement(baseElem, path);
                            if (handled.add(se1)) {
                                stack.add(se1);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(binding instanceof ITypedef) || !((type = (ct = (ITypedef)binding).getType()) instanceof IBinding)) continue;
                IBinding basecl = (IBinding)type;
                ICElement[] baseElems = IndexQueries.findRepresentative(index, basecl, this.fConverterFactory, null, projectFactory);
                String[] paths = IndexQueries.findRepresentitivePaths(index, basecl, this.fConverterFactory, null, projectFactory);
                if (baseElems.length <= 0) continue;
                ICElement baseElem = baseElems[0];
                String path = paths[0];
                THGraphNode baseGraphNode = this.addNode(baseElem, path);
                this.addMembers(index, baseGraphNode, basecl, projectFactory);
                this.addEdge(graphNode, baseGraphNode);
                StackElement se1 = new StackElement(baseElem, path);
                if (!handled.add(se1)) continue;
                stack.add(se1);
            }
            catch (DOMException e) {
                RDTLog.logError(e);
            }
            catch (CoreException e) {
                RDTLog.logError(e);
            }
        }
    }

    public void addSubClasses(IIndex index, IProgressMonitor monitor, ICProjectFactory projectFactory) {
        if (this.fInputNode == null) {
            return;
        }
        HashSet<StackElement> handled = new HashSet<StackElement>();
        ArrayList<StackElement> stack = new ArrayList<StackElement>();
        ICElement element = this.fInputNode.getElement();
        String path = this.fInputNode.getPath();
        StackElement stackElement = new StackElement(element, path);
        stack.add(stackElement);
        handled.add(stackElement);
        while (!stack.isEmpty()) {
            if (monitor.isCanceled()) {
                return;
            }
            StackElement se = (StackElement)stack.remove(stack.size() - 1);
            ICElement elem = se.fElement;
            THGraphNode graphNode = this.addNode(elem, se.fPath);
            try {
                IIndexBinding binding = IndexQueries.elementToBinding(index, elem, se.fPath);
                if (binding == null) continue;
                IIndexName[] names = index.findNames((IBinding)binding, 6);
                int i = 0;
                while (i < names.length) {
                    IIndexName subClassDef;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IIndexName indexName = names[i];
                    if (indexName.isBaseSpecifier() && (subClassDef = indexName.getEnclosingDefinition()) != null) {
                        IIndexBinding subClass = index.findBinding((IName)subClassDef);
                        ICElement[] subClassElems = IndexQueries.findRepresentative(index, (IBinding)subClass, this.fConverterFactory, null, projectFactory);
                        String[] paths = IndexQueries.findRepresentitivePaths(index, (IBinding)subClass, this.fConverterFactory, null, projectFactory);
                        if (subClassElems.length > 0) {
                            ICElement subClassElem = subClassElems[0];
                            String path1 = paths[0];
                            THGraphNode subGraphNode = this.addNode(subClassElem, path1);
                            this.addMembers(index, subGraphNode, (IBinding)subClass, projectFactory);
                            this.addEdge(subGraphNode, graphNode);
                            StackElement se1 = new StackElement(subClassElem, path1);
                            if (handled.add(se1)) {
                                stack.add(se1);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                RDTLog.logError(e);
            }
        }
    }

    private void addMembers(IIndex index, THGraphNode graphNode, IBinding binding, ICProjectFactory projectFactory) throws CoreException {
        if (graphNode.getMembers(false) == null) {
            ArrayList<ICElement> memberList = new ArrayList<ICElement>();
            try {
                if (binding instanceof ICPPClassType) {
                    ICPPClassType ct = (ICPPClassType)binding;
                    ICPPField[] members = ct.getDeclaredFields();
                    this.addMemberElements(index, (IBinding[])members, memberList, projectFactory);
                    members = ct.getDeclaredMethods();
                    this.addMemberElements(index, (IBinding[])members, memberList, projectFactory);
                } else if (binding instanceof ICompositeType) {
                    ICompositeType ct = (ICompositeType)binding;
                    IField[] members = ct.getFields();
                    this.addMemberElements(index, (IBinding[])members, memberList, projectFactory);
                } else if (binding instanceof IEnumeration) {
                    IEnumeration ct = (IEnumeration)binding;
                    IEnumerator[] members = ct.getEnumerators();
                    this.addMemberElements(index, (IBinding[])members, memberList, projectFactory);
                }
            }
            catch (DOMException dOMException) {}
            if (memberList.isEmpty()) {
                graphNode.setMembers(NO_MEMBERS);
            } else {
                graphNode.setMembers(memberList.toArray(new ICElement[memberList.size()]));
            }
        }
    }

    private void addMemberElements(IIndex index, IBinding[] members, List<ICElement> memberList, ICProjectFactory projectFactory) throws CoreException {
        int i = 0;
        while (i < members.length) {
            IBinding binding = members[i];
            ICElement[] elems = IndexQueries.findRepresentative(index, binding, this.fConverterFactory, null, projectFactory);
            if (elems.length > 0) {
                memberList.add(elems[0]);
            }
            ++i;
        }
    }

    public boolean isTrivial() {
        return this.fNodes.size() < 2;
    }

    public boolean isFileIndexed() {
        return this.fFileIsIndexed;
    }

    private class StackElement {
        public ICElement fElement;
        public String fPath;

        public int hashCode() {
            return this.fElement.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StackElement) {
                StackElement se = (StackElement)obj;
                return this.fElement.equals(se.fElement);
            }
            return false;
        }

        public StackElement(ICElement element, String path) {
            this.fElement = element;
            this.fPath = path;
        }

        private THGraph getOuterType() {
            return THGraph.this;
        }
    }
}

