/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.miners.StandaloneLogService;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

public class RemoteLocationConverter
implements IIndexLocationConverter {
    private DataStore _dataStore = null;
    private static final String CLASS_NAME = "CDTMiner-RemoteLocationConverter";

    public RemoteLocationConverter(DataStore _dataStore) {
        this._dataStore = _dataStore;
    }

    public RemoteLocationConverter() {
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        try {
            File rawFile = new File(raw);
            if (rawFile.isAbsolute()) {
                return new IndexFileLocation(new URI("file", null, raw, null, null), null);
            }
            return new IndexFileLocation(new URI(raw), null);
        }
        catch (URISyntaxException e) {
            if (this._dataStore != null) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
            } else {
                StandaloneLogService.getInstance().errorLog("CDTMiner-RemoteLocationConverter:" + e.toString(), e);
            }
            return null;
        }
    }

    public String toInternalFormat(IIndexFileLocation location) {
        return location.getURI().getPath();
    }
}

