/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.navigation;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.miners.OpenDeclarationHandler;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.ui.navigation.INavigationService;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ui.texteditor.ITextEditor;

public class LocalNavigationService
implements INavigationService {
    public OpenDeclarationResult openDeclaration(ITextEditor editor, String selectedText, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        try {
            monitor.beginTask("Open Declaration", -1);
            OpenDeclarationResult openDeclarationResult = LocalNavigationService.handleOpenDeclarationLocally((ITranslationUnit)workingCopy, selectedText, selectionStart, selectionLength);
            return openDeclarationResult;
        }
        finally {
            monitor.done();
        }
    }

    private static OpenDeclarationResult handleOpenDeclarationLocally(final ITranslationUnit translationUnit, final String selectedText, final int selectionStart, final int selectionLength) {
        IIndex index;
        try {
            index = CCorePlugin.getIndexManager().getIndex(translationUnit.getCProject(), 3);
        }
        catch (CoreException coreException) {
            return OpenDeclarationResult.failureUnexpectedError();
        }
        final OpenDeclarationHandler.INavigationErrorLogger logger = new OpenDeclarationHandler.INavigationErrorLogger(){

            public void logDebugMessage(String message) {
                RDTLog.logInfo((String)message);
            }

            public void logError(String message, Throwable e) {
                RDTLog.logError((Throwable)e, (String)message);
            }
        };
        final OpenDeclarationResult[] result = new OpenDeclarationResult[1];
        ASTCache.ASTRunnable astRunnable = new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                result[0] = OpenDeclarationHandler.doHandleOpenDeclaration((IASTTranslationUnit)ast, (ITranslationUnit)translationUnit, (String)selectedText, (int)selectionStart, (int)selectionLength, (IIndex)index, (OpenDeclarationHandler.INavigationErrorLogger)logger);
                return Status.OK_STATUS;
            }
        };
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return OpenDeclarationResult.failureUnexpectedError();
        }
        try {
            ASTProvider.getASTProvider().runOnAST((ICElement)translationUnit, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), astRunnable);
        }
        finally {
            index.releaseReadLock();
        }
        return result[0];
    }
}

