/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.parser.ParserMessages;
import org.eclipse.core.runtime.PlatformObject;

public class ProblemBinding
extends PlatformObject
implements IProblemBinding,
IASTInternalScope {
    public static ProblemBinding NOT_INITIALIZED = new ProblemBinding(null, 0);
    protected final int id;
    protected char[] arg;
    protected IASTNode node;
    private final String message;
    private IBinding[] candidateBindings;
    protected static final String[] errorMessages = new String[15];

    static {
        ProblemBinding.errorMessages[0] = ParserMessages.getString("ASTProblemFactory.error.semantic.nameNotFound");
        ProblemBinding.errorMessages[3] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.ambiguousLookup");
        ProblemBinding.errorMessages[4] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidType");
        ProblemBinding.errorMessages[5] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.circularInheritance");
        ProblemBinding.errorMessages[1] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidOverload");
        ProblemBinding.errorMessages[2] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidUsing");
        ProblemBinding.errorMessages[6] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.definitionNotFound");
        ProblemBinding.errorMessages[7] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.knrParameterDeclarationNotFound");
        ProblemBinding.errorMessages[8] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.labelStatementNotFound");
        ProblemBinding.errorMessages[10] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.invalidRedefinition");
        ProblemBinding.errorMessages[11] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.invalidRedeclaration");
        ProblemBinding.errorMessages[9] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.badScope");
        ProblemBinding.errorMessages[13] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.recursionInResolution");
        ProblemBinding.errorMessages[12] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.memberDeclNotFound");
        ProblemBinding.errorMessages[14] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.invalidTemplateArgs");
    }

    public ProblemBinding(IASTName name, int id) {
        this(name, id, null, null);
    }

    public ProblemBinding(IASTName name, int id, IBinding[] candidateBindings) {
        this(name, id, null, candidateBindings);
    }

    public ProblemBinding(IASTNode node, int id, char[] arg) {
        this(node, id, arg, null);
    }

    public ProblemBinding(IASTNode node, int id, char[] arg, IBinding[] candidateBindings) {
        this.message = null;
        this.id = id;
        this.arg = arg;
        this.node = node;
        this.candidateBindings = candidateBindings;
    }

    public EScopeKind getKind() {
        return EScopeKind.eLocal;
    }

    public IASTNode getASTNode() {
        return this.node;
    }

    public IBinding[] getCandidateBindings() {
        return this.candidateBindings != null ? this.candidateBindings : IBinding.EMPTY_BINDING_ARRAY;
    }

    public void setCandidateBindings(IBinding[] foundBindings) {
        this.candidateBindings = foundBindings;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        String msg;
        if (this.message != null) {
            return this.message;
        }
        String string = msg = this.id > 0 && this.id <= errorMessages.length ? errorMessages[this.id - 1] : "";
        if (this.arg == null && this.node instanceof IASTName) {
            this.arg = ((IASTName)this.node).toCharArray();
        }
        if (this.arg != null) {
            msg = MessageFormat.format((String)msg, (Object[])new Object[]{new String(this.arg)});
        }
        return msg;
    }

    public String getName() {
        return this.node instanceof IASTName ? new String(((IASTName)this.node).getSimpleID()) : "";
    }

    public char[] getNameCharArray() {
        return this.node instanceof IASTName ? ((IASTName)this.node).getSimpleID() : CharArrayUtils.EMPTY;
    }

    public IScope getScope() throws DOMException {
        throw new DOMException(this);
    }

    public IASTNode getPhysicalNode() {
        return this.getASTNode();
    }

    public Object clone() {
        return this;
    }

    public IScope getParent() throws DOMException {
        throw new DOMException(this);
    }

    public IBinding[] find(String name) throws DOMException {
        throw new DOMException(this);
    }

    public IName getScopeName() {
        return null;
    }

    public void addName(IASTName name) throws DOMException {
        throw new DOMException(this);
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        throw new DOMException(this);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        throw new DOMException(this);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        throw new DOMException(this);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        throw new DOMException(this);
    }

    public boolean isSameType(IType type) {
        return type == this;
    }

    public String getFileName() {
        if (this.node != null) {
            return this.node.getContainingFilename();
        }
        return "";
    }

    public int getLineNumber() {
        IASTFileLocation fileLoc;
        if (this.node != null && (fileLoc = this.node.getFileLocation()) != null) {
            return fileLoc.getStartingLineNumber();
        }
        return -1;
    }

    public void addBinding(IBinding binding) throws DOMException {
        throw new DOMException(this);
    }

    public ILinkage getLinkage() {
        return Linkage.NO_LINKAGE;
    }

    public String toString() {
        return this.getMessage();
    }

    public IBinding getOwner() throws DOMException {
        return this.node instanceof IASTName ? CPPVisitor.findNameOwner((IASTName)this.node, true) : null;
    }

    public void setASTNode(IASTName name) {
        if (name != null) {
            this.node = name;
            this.arg = null;
        }
    }

    public void populateCache() {
    }
}

