/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.ui.menus;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.rephraserengine.core.refactorings.IEditorRefactoring;
import org.eclipse.rephraserengine.core.refactorings.IRefactoring;
import org.eclipse.rephraserengine.core.refactorings.IResourceRefactoring;
import org.eclipse.rephraserengine.core.resources.IResourceFilter;
import org.eclipse.rephraserengine.internal.ui.actions.RefactoringAction;
import org.eclipse.rephraserengine.ui.WorkbenchSelectionInfo;
import org.eclipse.rephraserengine.ui.menus.Messages;
import org.eclipse.rephraserengine.ui.refactoring.CustomUserInputPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RefactorMenu
extends CompoundContributionItem {
    private static final String REFACTORING_EXTENSION_POINT_ID = "org.eclipse.rephraserengine.ui.refactoring.refactorings";
    private WorkbenchSelectionInfo selection;

    protected IContributionItem[] getContributionItems() {
        this.selection = new WorkbenchSelectionInfo();
        LinkedList<IContributionItem> result = this.loadRefactoringsFromExtensionPoint();
        return this.fixMenu(result);
    }

    private IContributionItem[] fixMenu(LinkedList<IContributionItem> result) {
        if (!result.isEmpty() && result.getLast() instanceof SeparatorContributionItem) {
            result.removeLast();
        }
        if (result.isEmpty()) {
            return new IContributionItem[]{new EmptyMenuContributionItem()};
        }
        return result.toArray(new IContributionItem[result.size()]);
    }

    private LinkedList<IContributionItem> loadRefactoringsFromExtensionPoint() {
        return this.loadRefactoringsFrom(Platform.getExtensionRegistry().getConfigurationElementsFor(REFACTORING_EXTENSION_POINT_ID));
    }

    private LinkedList<IContributionItem> loadRefactoringsFrom(IConfigurationElement[] configs) {
        LinkedList<IContributionItem> result = new LinkedList<IContributionItem>();
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            try {
                this.processConfigElt(elt, result);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    private void processConfigElt(IConfigurationElement elt, LinkedList<IContributionItem> result) throws CoreException {
        if (elt.getName().equals("resourceFilter")) {
            IResourceFilter resourceFilter = (IResourceFilter)elt.createExecutableExtension("class");
            this.selection = new WorkbenchSelectionInfo(resourceFilter);
        } else if (elt.getName().equals("group")) {
            if (!result.isEmpty() && !(result.getLast() instanceof SeparatorContributionItem)) {
                result.add((IContributionItem)new SeparatorContributionItem());
            }
            result.addAll(this.loadRefactoringsFrom(elt.getChildren()));
        } else if (elt.getName().equals("resourceRefactoring")) {
            this.addResourceRefactoring(elt, result);
        } else if (elt.getName().equals("editorRefactoring")) {
            this.addEditorRefactoring(elt, result);
        } else if (elt.getName().equals("command")) {
            this.addCommand(elt, result);
        }
    }

    private void addResourceRefactoring(IConfigurationElement elt, LinkedList<IContributionItem> result) throws CoreException {
        if (this.selection.someFilesAreSelected()) {
            if (elt.getAttribute("class") != null && this.environmentOK(elt)) {
                try {
                    IResourceRefactoring refactoring = (IResourceRefactoring)elt.createExecutableExtension("class");
                    String label = elt.getAttribute("label");
                    CustomUserInputPage customInputPage = elt.getAttribute("inputPage") == null ? null : (CustomUserInputPage)((Object)elt.createExecutableExtension("inputPage"));
                    result.add((IContributionItem)new ResourceRefactoringContributionItem(refactoring, label, customInputPage, this.selection));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (elt.getAttribute("command") != null) {
                result.add((IContributionItem)this.commandContribution(elt.getAttribute("command")));
            }
        }
    }

    private void addEditorRefactoring(IConfigurationElement elt, LinkedList<IContributionItem> result) throws CoreException {
        if (this.selection.editingAnIFile() && this.selection.isTextSelectedInEditor()) {
            if (elt.getAttribute("class") != null && this.environmentOK(elt)) {
                try {
                    IEditorRefactoring refactoring = (IEditorRefactoring)elt.createExecutableExtension("class");
                    String label = elt.getAttribute("label");
                    CustomUserInputPage customInputPage = elt.getAttribute("inputPage") == null ? null : (CustomUserInputPage)((Object)elt.createExecutableExtension("inputPage"));
                    result.add((IContributionItem)new EditorRefactoringContributionItem(refactoring, label, customInputPage, this.selection.getFileInEditor(), this.selection.getSelectionInEditor()));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (elt.getAttribute("command") != null) {
                result.add((IContributionItem)this.commandContribution(elt.getAttribute("command")));
            }
        }
    }

    private boolean environmentOK(IConfigurationElement elt) {
        if (elt.getAttribute("require_env") != null) {
            return System.getenv(elt.getAttribute("require_env")) != null;
        }
        return true;
    }

    private void addCommand(IConfigurationElement elt, LinkedList<IContributionItem> result) {
        result.add((IContributionItem)this.commandContribution(elt.getAttribute("id")));
    }

    private CommandContributionItem commandContribution(String commandID) {
        return new CommandContributionItem((IServiceLocator)Workbench.getInstance().getActiveWorkbenchWindow(), null, commandID, null, null, null, null, null, null, null, 8);
    }

    private static class EditorRefactoringContributionItem
    extends ContributionItem {
        private IEditorRefactoring refactoring;
        private String label;
        private CustomUserInputPage customInputPage;
        private IFile fileInEditor;
        private ITextSelection textSelection;

        public EditorRefactoringContributionItem(IEditorRefactoring refactoring, String label, CustomUserInputPage customInputPage, IFile fileInEditor, ITextSelection textSelection) {
            this.refactoring = refactoring;
            this.label = label != null ? label : String.valueOf(refactoring.getName()) + "...";
            this.customInputPage = customInputPage;
            this.fileInEditor = fileInEditor;
            this.textSelection = textSelection;
        }

        public void fill(Menu parent, int index) {
            MenuItem menuItem = new MenuItem(parent, 0, index);
            menuItem.setText(this.label);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditorRefactoringContributionItem.this.refactoring.initialize(EditorRefactoringContributionItem.this.fileInEditor, EditorRefactoringContributionItem.this.textSelection);
                    new RefactoringAction((IRefactoring)EditorRefactoringContributionItem.this.refactoring, EditorRefactoringContributionItem.this.customInputPage).run();
                }
            });
        }
    }

    private static class EmptyMenuContributionItem
    extends ContributionItem {
        private EmptyMenuContributionItem() {
        }

        public void fill(Menu parent, int index) {
            MenuItem item = new MenuItem(parent, 0, index);
            item.setText(Messages.RefactorMenu_NoRefactoringsAvailable);
            item.setEnabled(false);
        }
    }

    private static class ResourceRefactoringContributionItem
    extends ContributionItem {
        private IResourceRefactoring refactoring;
        private String label;
        private CustomUserInputPage customInputPage;
        private WorkbenchSelectionInfo selection;

        public ResourceRefactoringContributionItem(IResourceRefactoring refactoring, String label, CustomUserInputPage customInputPage, WorkbenchSelectionInfo selection) {
            this.refactoring = refactoring;
            this.label = label != null ? label : String.valueOf(refactoring.getName()) + "...";
            this.customInputPage = customInputPage;
            this.selection = selection;
        }

        public void fill(Menu parent, int index) {
            MenuItem menuItem = new MenuItem(parent, 0, index);
            menuItem.setText(this.label);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceRefactoringContributionItem.this.refactoring.initialize(ResourceRefactoringContributionItem.this.selection.getAllFilesInSelectedResources());
                    new RefactoringAction((IRefactoring)ResourceRefactoringContributionItem.this.refactoring, ResourceRefactoringContributionItem.this.customInputPage).run();
                }
            });
        }
    }

    private static class SeparatorContributionItem
    extends ContributionItem {
        private SeparatorContributionItem() {
        }

        public void fill(Menu parent, int index) {
            new MenuItem(parent, 2, index);
        }
    }
}

