/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelExec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.remotetools.core.IRemoteDownloadExecution;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;

public class DownloadExecution
extends KillableExecution
implements IRemoteDownloadExecution {
    String remoteFile;
    OutputStream sinkStream;
    ByteArrayOutputStream errorStream;
    InputStream inputStream;

    public DownloadExecution(ExecutionManager executionManager, String remoteFile, OutputStream sink) throws RemoteConnectionException {
        super(executionManager);
        this.remoteFile = remoteFile;
        this.sinkStream = sink;
        this.errorStream = new ByteArrayOutputStream();
    }

    public InputStream getInputStreamFromProcessRemoteFile() throws IOException {
        if (this.sinkStream != null) {
            throw new IllegalStateException();
        }
        return this.inputStream;
    }

    public void startExecution() throws RemoteConnectionException {
        ChannelExec channel = this.createChannel(false);
        IRemotePathTools pathTool = this.getExecutionManager().getRemotePathTools();
        this.setCommandLine("cat " + pathTool.quote(this.remoteFile, true));
        if (this.sinkStream != null) {
            channel.setOutputStream(this.sinkStream);
            this.inputStream = null;
        } else {
            try {
                this.inputStream = channel.getInputStream();
            }
            catch (IOException e) {
                throw new RemoteConnectionException(Messages.DownloadExecution_DownloadExecution_FailedCreateDownload, e);
            }
        }
        channel.setErrStream((OutputStream)this.errorStream);
        super.startExecution();
        Debug.println("Downloading " + this.remoteFile);
    }

    public String getErrorMessage() {
        return this.errorStream.toString();
    }
}

