/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.SpawnerInputStream;
import org.eclipse.cdt.utils.spawner.SpawnerOutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class Spawner
extends Process {
    public int NOOP = 0;
    public int HUP = 1;
    public int KILL = 9;
    public int TERM = 15;
    public int INT = 2;
    public int CTRLC = 1000;
    int pid = 0;
    int status;
    int[] fChannels = new int[3];
    boolean isDone;
    OutputStream out;
    InputStream in;
    InputStream err;
    private PTY fPty;

    static {
        try {
            System.loadLibrary("spawner");
        }
        catch (SecurityException e) {
            CCorePlugin.log((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    public Spawner(String command, boolean bNoRedirect) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        if (bNoRedirect) {
            this.exec_detached(cmdarray, new String[0], ".");
        } else {
            this.exec(cmdarray, new String[0], ".");
        }
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir) throws IOException {
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir, PTY pty) throws IOException {
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.fPty = pty;
        this.exec_pty(cmdarray, envp, dirpath, pty);
    }

    protected Spawner(String command) throws IOException {
        this(command, null);
    }

    protected Spawner(String[] cmdarray) throws IOException {
        this(cmdarray, null);
    }

    protected Spawner(String[] cmdarray, String[] envp) throws IOException {
        this(cmdarray, envp, null);
    }

    protected Spawner(String cmd, String[] envp) throws IOException {
        this(cmd, envp, null);
    }

    protected Spawner(String command, String[] envp, File dir) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    public InputStream getInputStream() {
        if (this.in == null) {
            this.in = this.fPty != null ? this.fPty.getInputStream() : new SpawnerInputStream(this.fChannels[1]);
        }
        return this.in;
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = this.fPty != null ? this.fPty.getOutputStream() : new SpawnerOutputStream(this.fChannels[0]);
        }
        return this.out;
    }

    public InputStream getErrorStream() {
        if (this.err == null) {
            this.err = this.fPty != null && !this.fPty.isConsole() ? new InputStream(){

                public int read() throws IOException {
                    return -1;
                }
            } : new SpawnerInputStream(this.fChannels[2]);
        }
        return this.err;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        try {
            if (this.err == null) {
                this.getErrorStream().close();
            }
            if (this.in == null) {
                this.getInputStream().close();
            }
            if (this.out == null) {
                this.getOutputStream().close();
            }
        }
        catch (IOException iOException) {}
        return this.status;
    }

    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.status;
    }

    public synchronized void destroy() {
        this.terminate();
        try {
            if (this.err == null) {
                this.getErrorStream().close();
            }
            if (this.in == null) {
                this.getInputStream().close();
            }
            if (this.out == null) {
                this.getOutputStream().close();
            }
        }
        catch (IOException iOException) {}
        if (!this.isDone) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isDone) {
            this.kill();
        }
    }

    public int interrupt() {
        return this.raise(this.pid, this.INT);
    }

    public int interruptCTRLC() {
        if (Platform.getOS().equals("win32")) {
            return this.raise(this.pid, this.CTRLC);
        }
        return this.interrupt();
    }

    public int hangup() {
        return this.raise(this.pid, this.HUP);
    }

    public int kill() {
        return this.raise(this.pid, this.KILL);
    }

    public int terminate() {
        return this.raise(this.pid, this.TERM);
    }

    public boolean isRunning() {
        return this.raise(this.pid, this.NOOP) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        Reaper reaper = new Reaper(cmdarray, envp, dirpath);
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        synchronized (spawner) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.pid == -1) {
            throw new IOException(reaper.getErrorMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec_pty(String[] cmdarray, String[] envp, String dirpath, PTY pty) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        final String slaveName = pty.getSlaveName();
        final int masterFD = pty.getMasterFD().getFD();
        final boolean console = pty.isConsole();
        Reaper reaper = new Reaper(cmdarray, envp, dirpath){

            int execute(String[] cmd, String[] env, String dir, int[] channels) throws IOException {
                return Spawner.this.exec2(cmd, env, dir, channels, slaveName, masterFD, console);
            }
        };
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        synchronized (spawner) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec_tty error:" + reaper.getErrorMessage());
        }
    }

    public void exec_detached(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        this.pid = this.exec1(cmdarray, envp, dirpath);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
    }

    native int exec0(String[] var1, String[] var2, String var3, int[] var4) throws IOException;

    native int exec1(String[] var1, String[] var2, String var3) throws IOException;

    native int exec2(String[] var1, String[] var2, String var3, int[] var4, String var5, int var6, boolean var7) throws IOException;

    public native int raise(int var1, int var2);

    native int waitFor(int var1);

    class Reaper
    extends Thread {
        String[] fCmdarray;
        String[] fEnvp;
        String fDirpath;
        volatile Throwable fException;

        public Reaper(String[] array, String[] env, String dir) {
            super("Spawner Reaper");
            this.fCmdarray = array;
            this.fEnvp = env;
            this.fDirpath = dir;
            this.fException = null;
        }

        int execute(String[] cmdarray, String[] envp, String dir, int[] channels) throws IOException {
            return Spawner.this.exec0(cmdarray, envp, dir, channels);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Spawner.this.pid = this.execute(this.fCmdarray, this.fEnvp, this.fDirpath, Spawner.this.fChannels);
            }
            catch (Exception e) {
                Spawner.this.pid = -1;
                this.fException = e;
            }
            Spawner spawner = Spawner.this;
            synchronized (spawner) {
                Spawner.this.notifyAll();
            }
            if (Spawner.this.pid != -1) {
                Spawner.this.status = Spawner.this.waitFor(Spawner.this.pid);
                spawner = Spawner.this;
                synchronized (spawner) {
                    Spawner.this.isDone = true;
                    Spawner.this.notifyAll();
                }
            }
        }

        public String getErrorMessage() {
            String reason = this.fException != null ? this.fException.getMessage() : "Unknown reason";
            return NLS.bind((String)CCorePlugin.getResourceString((String)"Util.error.cannotRun"), (Object)this.fCmdarray[0], (Object)reason);
        }
    }
}

