/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.generic.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rm.generic.core.GenericRMCorePlugin;
import org.osgi.framework.Bundle;

public class GenericRMDefaults {
    public static String LAUNCH_CMD = null;
    public static String DEBUG_CMD = null;
    public static String PATH = null;
    private static String defaultsResourcePath = "/data/defaults.properties";

    public static void loadDefaults() throws CoreException {
        Path defaultsPropertiesPath = new Path(defaultsResourcePath);
        Bundle bundle = GenericRMCorePlugin.getDefault().getBundle();
        Properties properties = GenericRMDefaults.read(defaultsPropertiesPath, bundle);
        LAUNCH_CMD = GenericRMDefaults.getString(bundle, properties, "LAUNCH_CMD");
        DEBUG_CMD = GenericRMDefaults.getString(bundle, properties, "DEBUG_CMD");
        PATH = GenericRMDefaults.getString(bundle, properties, "PATH");
        assert (LAUNCH_CMD != null);
        assert (DEBUG_CMD != null);
        assert (PATH != null);
    }

    public static Properties read(Path defaultsPropertiesPath, Bundle bundle) throws CoreException {
        Properties properties = new Properties();
        try {
            InputStream inStream = FileLocator.openStream((Bundle)bundle, (IPath)defaultsPropertiesPath, (boolean)false);
            properties.load(inStream);
        }
        catch (IOException e) {
            throw GenericRMCorePlugin.coreErrorException("Failed to read properties file with default preferences", e);
        }
        return properties;
    }

    public static String getString(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)"Missing default value for {0}", (Object)key)));
        }
        return value;
    }

    public static int getInteger(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = GenericRMDefaults.getString(bundle, properties, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)"Failed to parse integer default value for {0}", (Object)key)));
        }
    }

    public static boolean getBoolean(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = GenericRMDefaults.getString(bundle, properties, key);
        return Boolean.parseBoolean(value);
    }
}

