/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.ui.RSEUtils;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.wizards.IIndexFilePathChangeListener;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteBuildServiceFileLocationWidget
extends Composite {
    private IRemoteConnection fRemoteConnection = null;
    private IRemoteServices fRemoteServices = null;
    private final Text text;
    private final Button browseButton;
    private final Button defaultButton;
    private final ListenerList pathListeners = new ListenerList();
    private final Map<String, String> previousSelections = new HashMap<String, String>();

    public RemoteBuildServiceFileLocationWidget(Composite parent, int style, final IRemoteServices remoteServices, IRemoteConnection initialConnection, String defaultPath) {
        super(parent, style);
        this.fRemoteServices = remoteServices;
        this.fRemoteConnection = initialConnection;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString("RemoteBuildServiceFileLocationWidget.1"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        this.text = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = RemoteBuildServiceFileLocationWidget.this.text.getText();
                RemoteBuildServiceFileLocationWidget.this.previousSelections.put(RemoteBuildServiceFileLocationWidget.key(remoteServices, RemoteBuildServiceFileLocationWidget.this.fRemoteConnection), path);
                Object[] objectArray = RemoteBuildServiceFileLocationWidget.this.pathListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IIndexFilePathChangeListener)listener).pathChanged(path);
                    ++n2;
                }
            }
        });
        this.browseButton = new Button((Composite)group, 0);
        this.browseButton.setText(Messages.getString("IndexFileLocationWidget.1"));
        this.browseButton.setLayoutData((Object)new GridData(768));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteBuildServiceFileLocationWidget.this.browse();
            }
        });
        this.defaultButton = new Button((Composite)group, 0);
        this.defaultButton.setText(Messages.getString("IndexFileLocationWidget.2"));
        this.defaultButton.setLayoutData((Object)new GridData(768));
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteBuildServiceFileLocationWidget.this.restoreDefault();
            }
        });
        if (defaultPath != null) {
            this.text.setText(defaultPath);
        }
    }

    public IRemoteConnection getConnection() {
        return this.fRemoteConnection;
    }

    public static String getDefaultPath(IRemoteServices remoteServices, IRemoteConnection connection) {
        String homeDir;
        if (connection.isOpen() && (homeDir = connection.getProperty("user.home")) != null) {
            IFileStore homeStore = remoteServices.getFileManager(connection).getResource(homeDir);
            URI uri = homeStore.toURI();
            String pathString = EFSExtensionManager.getDefault().getPathFromURI(uri);
            if (pathString != null) {
                Path path = new Path(pathString);
                path = path.append(RSEUtils.DEFAULT_CONFIG_DIR_NAME);
                return path.toString();
            }
        }
        return null;
    }

    private static String key(IRemoteServices remoteServices, IRemoteConnection connection) {
        return String.valueOf(remoteServices.getName()) + ":" + connection.getName();
    }

    public String getConfigLocationPath() {
        return this.text.getText();
    }

    public void addPathListener(IIndexFilePathChangeListener listener) {
        this.pathListeners.add((Object)listener);
    }

    public void removePathListener(IIndexFilePathChangeListener listener) {
        this.pathListeners.remove((Object)listener);
    }

    private void browse() {
        IRemoteUIServices uiServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fRemoteServices);
        IRemoteUIFileManager fmConnection = uiServices.getUIFileManager();
        fmConnection.setConnection(this.fRemoteConnection);
        String remotePath = fmConnection.browseDirectory(this.getShell(), Messages.getString("RemoteBuildServiceFileLocationWidget.0"), this.text.getText(), 0);
        if (remotePath != null) {
            this.text.setText(remotePath);
        }
    }

    private void restoreDefault() {
        String defaultPath = RemoteBuildServiceFileLocationWidget.getDefaultPath(this.fRemoteServices, this.fRemoteConnection);
        this.text.setText(defaultPath);
    }

    public void update(IRemoteServices services, IRemoteConnection connection) {
        this.fRemoteServices = services;
        this.fRemoteConnection = connection;
        String defaultPath = RemoteBuildServiceFileLocationWidget.getDefaultPath(this.fRemoteServices, this.fRemoteConnection);
        this.text.setText(defaultPath);
    }
}

