/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class TypeMarshalBuffer
implements ITypeMarshalBuffer {
    public static final byte[] EMPTY = new byte[6];
    public static final byte NULL_TYPE = 0;
    public static final byte INDIRECT_TYPE = -1;
    public static final byte BINDING_TYPE = -2;
    private final PDOMLinkage fLinkage;
    private int fPos;
    private byte[] fBuffer;

    static {
        assert (EMPTY.length == 6);
    }

    public TypeMarshalBuffer(PDOMLinkage linkage) {
        this.fLinkage = linkage;
    }

    public TypeMarshalBuffer(PDOMLinkage linkage, byte[] data) {
        this.fLinkage = linkage;
        this.fBuffer = data;
    }

    public int getPosition() {
        return this.fPos;
    }

    public byte[] getBuffer() {
        return this.fBuffer;
    }

    public void marshalType(IType type) throws CoreException {
        if (type instanceof IBinding) {
            PDOMBinding pb = this.fLinkage.addTypeBinding((IBinding)((Object)type));
            if (pb == null) {
                this.putByte((byte)0);
            } else {
                this.putByte((byte)-2);
                this.putByte((byte)0);
                this.putRecordPointer(pb.getRecord());
            }
        } else if (type instanceof ISerializableType) {
            ((ISerializableType)((Object)type)).marshal(this);
        } else {
            assert (type == null) : "Cannot serialize " + ASTTypeUtil.getType(type) + "(" + type.getClass().getName() + ")";
            this.putByte((byte)0);
        }
    }

    private void request(int i) {
        if (this.fBuffer == null) {
            this.fBuffer = i <= 6 ? new byte[6] : new byte[i];
        } else {
            int needLen = this.fPos + i;
            int bufLen = this.fBuffer.length;
            if (needLen > bufLen) {
                needLen = Math.max(needLen, 2 * bufLen);
                byte[] newBuffer = new byte[needLen];
                System.arraycopy(this.fBuffer, 0, newBuffer, 0, this.fPos);
                this.fBuffer = newBuffer;
            }
        }
    }

    public void putByte(byte b) {
        this.request(1);
        this.fBuffer[this.fPos++] = b;
    }

    public int getByte() throws CoreException {
        if (this.fPos + 1 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        return 0xFF & this.fBuffer[this.fPos++];
    }

    public CoreException unmarshallingError() {
        return new CoreException(CCorePlugin.createStatus((String)"Unmarshalling error"));
    }

    public CoreException marshallingError() {
        return new CoreException(CCorePlugin.createStatus((String)"Marshalling error"));
    }

    public void putShort(short value) {
        this.request(2);
        this.fBuffer[this.fPos++] = (byte)(value >> 8);
        this.fBuffer[this.fPos++] = (byte)value;
    }

    public int getShort() throws CoreException {
        if (this.fPos + 2 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        int byte1 = 0xFF & this.fBuffer[this.fPos++];
        int byte2 = 0xFF & this.fBuffer[this.fPos++];
        return byte1 << 8 | byte2 & 0xFF;
    }

    private void putRecordPointer(long record) {
        this.request(4);
        Chunk.putRecPtr(record, this.fBuffer, this.fPos);
        this.fPos += 4;
    }

    private long getRecordPointer() throws CoreException {
        int pos = this.fPos;
        this.fPos += 4;
        if (this.fPos > this.fBuffer.length) {
            this.fPos = this.fBuffer.length;
            throw this.unmarshallingError();
        }
        return Chunk.getRecPtr(this.fBuffer, pos);
    }

    public IValue getValue() throws CoreException {
        int replen = this.getShort();
        int unknwonLen = this.getShort();
        char[] rep = new char[replen];
        int i = 0;
        while (i < replen) {
            rep[i] = (char)this.getShort();
            ++i;
        }
        ICPPUnknownBinding[] unknown = new ICPPUnknownBinding[unknwonLen];
        int i2 = 0;
        while (i2 < unknwonLen) {
            long ptr = this.getRecordPointer();
            PDOMBinding b = this.fLinkage.getBinding(ptr);
            if (b instanceof ICPPUnknownBinding) {
                unknown[i2] = (ICPPUnknownBinding)((Object)b);
            }
            ++i2;
        }
        return Value.fromInternalRepresentation(rep, unknown);
    }

    public void putValue(IValue value) throws CoreException {
        char[] rep = value.getInternalExpression();
        IBinding[] unknown = value.getUnknownBindings();
        this.putShort((short)rep.length);
        this.putShort((short)unknown.length);
        int len = rep.length & 0xFFFF;
        int i = 0;
        while (i < len) {
            this.putShort((short)rep[i]);
            ++i;
        }
        len = unknown.length & 0xFFFF;
        i = 0;
        while (i < len) {
            PDOMBinding uv = this.fLinkage.addUnknownValue(unknown[i]);
            this.putRecordPointer(uv != null ? uv.getRecord() : 0L);
            ++i;
        }
    }

    public IType unmarshalType() throws CoreException {
        if (this.fPos >= this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        byte firstByte = this.fBuffer[this.fPos];
        if (firstByte == -2) {
            this.fPos += 2;
            long rec = this.getRecordPointer();
            return (IType)((Object)this.fLinkage.getNode(rec));
        }
        if (firstByte == 0) {
            ++this.fPos;
            return null;
        }
        return this.fLinkage.unmarshalType(this);
    }
}

