/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.launch.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.RuntimeProcess;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            if (!(launch instanceof IPLaunch)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.ParallelLaunchConfigurationDelegate_Invalid_launch_object));
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            progress.setTaskName(NLS.bind((String)Messages.ParallelLaunchConfigurationDelegate_3, (Object)configuration.getName()));
            progress.setWorkRemaining(90);
            if (progress.isCanceled()) {
                return;
            }
            IPDebugger debugger = null;
            progress.worked(10);
            progress.subTask(Messages.ParallelLaunchConfigurationDelegate_4);
            AttributeManager attrManager = this.getAttributeManager(configuration, mode);
            this.copyExecutable(configuration, (IProgressMonitor)progress.newChild(10));
            this.doPreLaunchSynchronization(configuration, (IProgressMonitor)progress.newChild(10));
            this.switchPerspective(DebugUITools.getLaunchPerspective((ILaunchConfigurationType)configuration.getType(), (String)mode));
            try {
                if (mode.equals("debug")) {
                    this.showPTPDebugView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
                    progress.subTask(Messages.ParallelLaunchConfigurationDelegate_6);
                    IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
                    debugger = debugConfig.getDebugger();
                    debugger.initialize(configuration, attrManager, (IProgressMonitor)progress.newChild(10));
                    if (progress.isCanceled()) {
                        return;
                    }
                    attrManager.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(Boolean.valueOf(true)));
                    attrManager.addAttribute((IAttribute)JobAttributes.getDebuggerIdAttributeDefinition().create(debugConfig.getID()));
                }
                progress.worked(10);
                progress.subTask(Messages.ParallelLaunchConfigurationDelegate_7);
                this.submitJob(configuration, mode, (IPLaunch)launch, attrManager, debugger, (IProgressMonitor)progress.newChild(40));
                progress.worked(10);
                return;
            }
            catch (CoreException e) {
                if (debugger != null) {
                    debugger.cleanup((IPLaunch)launch);
                }
                if (e.getStatus().getCode() == 8) return;
                throw e;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void terminateJob(IPJob job) {
        try {
            IResourceManager rm = job.getQueue().getResourceManager();
            rm.terminateJob(job);
        }
        catch (CoreException e1) {
            PTPLaunchPlugin.log(e1);
        }
    }

    protected void doCleanupLaunch(ILaunchConfiguration configuration, String mode, IPLaunch launch) {
        if (mode.equals("debug")) {
            try {
                IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
                IPDebugger debugger = debugConfig.getDebugger();
                debugger.cleanup(launch);
            }
            catch (CoreException e) {
                PTPLaunchPlugin.log(e);
            }
        }
    }

    protected void doCompleteJobLaunch(ILaunchConfiguration configuration, String mode, final IPLaunch launch, AttributeManager mgr, final IPDebugger debugger, final IPJob job) {
        launch.setAttribute(ElementAttributes.getIdAttributeDefinition().getId(), job.getID());
        if (mode.equals("debug")) {
            launch.setPJob(job);
            try {
                this.setDefaultSourceLocator((ILaunch)launch, configuration);
                final IProject project = this.verifyProject(configuration);
                final IPath execPath = this.verifyExecutablePath(configuration);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.ParallelLaunchConfigurationDelegate_5, 10);
                                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                                try {
                                    try {
                                        IPSession session = PTPDebugCorePlugin.getDebugModel().createDebugSession(debugger, launch, project, execPath, (IProgressMonitor)subMon.newChild(2));
                                        String app = ((StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getExecutableNameAttributeDefinition())).getValueAsString();
                                        String path = ((StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getExecutablePathAttributeDefinition())).getValueAsString();
                                        String cwd = ((StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValueAsString();
                                        List args = ((ArrayAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getProgramArgumentsAttributeDefinition())).getValue();
                                        session.connectToDebugger((IProgressMonitor)subMon.newChild(8), app, path, cwd, args.toArray(new String[args.size()]));
                                    }
                                    catch (CoreException e) {
                                        PTPDebugCorePlugin.getDebugModel().shutdownSession(job);
                                        throw new InvocationTargetException(e, e.getLocalizedMessage());
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        try {
                            new ProgressMonitorDialog(PTPLaunchPlugin.getActiveWorkbenchShell()).run(true, true, runnable);
                        }
                        catch (InterruptedException interruptedException) {
                            ParallelLaunchConfigurationDelegate.this.terminateJob(job);
                        }
                        catch (InvocationTargetException e) {
                            PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_0, e.getTargetException());
                            PTPLaunchPlugin.log(e.getCause());
                            ParallelLaunchConfigurationDelegate.this.terminateJob(job);
                        }
                    }
                });
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_1, e.getStatus());
                        PTPLaunchPlugin.log(e);
                        ParallelLaunchConfigurationDelegate.this.terminateJob(job);
                    }
                });
            }
        } else {
            new RuntimeProcess(launch, job, null);
        }
    }

    protected void showPTPDebugView(final String viewID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        try {
                            page.showView(viewID, null, 3);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    }

    protected void switchPerspective(final String perspectiveID) {
        if (perspectiveID != null) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage page;
                        IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                        if (window != null && (page = window.getActivePage()) != null) {
                            if (page.getPerspective().getId().equals(perspectiveID)) {
                                return;
                            }
                            try {
                                window.getWorkbench().showPerspective(perspectiveID, window);
                            }
                            catch (WorkbenchException workbenchException) {}
                        }
                    }
                });
            }
        }
    }
}

