/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumScope;

public class CPPASTEnumerationSpecifier
extends CPPASTBaseDeclSpecifier
implements IASTInternalEnumerationSpecifier,
ICPPASTEnumerationSpecifier {
    private boolean fIsScoped;
    private boolean fIsOpaque;
    private IASTName fName;
    private ICPPASTDeclSpecifier fBaseType;
    private IASTEnumerationSpecifier.IASTEnumerator[] fItems = null;
    private int fItemPos = -1;
    private boolean fValuesComputed = false;
    private CPPEnumScope fScope;

    public CPPASTEnumerationSpecifier() {
    }

    public CPPASTEnumerationSpecifier(boolean isScoped, IASTName name, ICPPASTDeclSpecifier baseType) {
        this.fIsScoped = isScoped;
        this.setName(name);
        this.setBaseType(baseType);
    }

    public CPPASTEnumerationSpecifier copy() {
        CPPASTEnumerationSpecifier copy = new CPPASTEnumerationSpecifier(this.fIsScoped, this.fName == null ? null : this.fName.copy(), this.fBaseType == null ? null : this.fBaseType.copy());
        copy.fIsOpaque = this.fIsOpaque;
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = this.getEnumerators();
        int n = iASTEnumeratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
            copy.addEnumerator(enumerator == null ? null : enumerator.copy());
            ++n2;
        }
        this.copyBaseDeclSpec(copy);
        return copy;
    }

    public boolean startValueComputation() {
        if (this.fValuesComputed) {
            return false;
        }
        this.fValuesComputed = true;
        return true;
    }

    public void addEnumerator(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.assertNotFrozen();
        if (enumerator != null) {
            enumerator.setParent(this);
            enumerator.setPropertyInParent(ENUMERATOR);
            this.fItems = (IASTEnumerationSpecifier.IASTEnumerator[])ArrayUtil.append(IASTEnumerationSpecifier.IASTEnumerator.class, this.fItems, ++this.fItemPos, enumerator);
        }
    }

    public IASTEnumerationSpecifier.IASTEnumerator[] getEnumerators() {
        if (this.fItems == null) {
            return IASTEnumerationSpecifier.IASTEnumerator.EMPTY_ENUMERATOR_ARRAY;
        }
        this.fItems = (IASTEnumerationSpecifier.IASTEnumerator[])ArrayUtil.removeNullsAfter(IASTEnumerationSpecifier.IASTEnumerator.class, this.fItems, this.fItemPos);
        return this.fItems;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ENUMERATION_NAME);
        }
    }

    public IASTName getName() {
        return this.fName;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (this.fBaseType != null && !this.fBaseType.accept(action)) {
            return false;
        }
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = this.getEnumerators();
        int n = iASTEnumeratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator e = iASTEnumeratorArray[n2];
            if (!e.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitDeclSpecifiers || action.leave(this) != 2;
    }

    public int getRoleForName(IASTName n) {
        if (this.fName == n) {
            return this.isOpaque() ? 0 : 2;
        }
        return 3;
    }

    public void setIsScoped(boolean isScoped) {
        this.assertNotFrozen();
        this.fIsScoped = isScoped;
    }

    public boolean isScoped() {
        return this.fIsScoped;
    }

    public void setBaseType(ICPPASTDeclSpecifier baseType) {
        this.assertNotFrozen();
        this.fBaseType = baseType;
        if (baseType != null) {
            baseType.setParent(this);
            baseType.setPropertyInParent(BASE_TYPE);
        }
    }

    public ICPPASTDeclSpecifier getBaseType() {
        return this.fBaseType;
    }

    public void setIsOpaque(boolean isOpaque) {
        this.assertNotFrozen();
        this.fIsOpaque = isOpaque;
    }

    public boolean isOpaque() {
        return this.fIsOpaque;
    }

    public ICPPScope getScope() {
        if (this.isOpaque()) {
            return null;
        }
        if (this.fScope == null) {
            this.fScope = new CPPEnumScope(this);
        }
        return this.fScope;
    }
}

