/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.Enumeration;
import org.eclipse.ptp.internal.rdt.core.model.Enumerator;
import org.eclipse.ptp.internal.rdt.core.model.Field;
import org.eclipse.ptp.internal.rdt.core.model.Function;
import org.eclipse.ptp.internal.rdt.core.model.FunctionDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.FunctionTemplate;
import org.eclipse.ptp.internal.rdt.core.model.FunctionTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.IHasManagedLocation;
import org.eclipse.ptp.internal.rdt.core.model.IHasRemotePath;
import org.eclipse.ptp.internal.rdt.core.model.Method;
import org.eclipse.ptp.internal.rdt.core.model.MethodDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.MethodTemplate;
import org.eclipse.ptp.internal.rdt.core.model.MethodTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.Namespace;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulation;
import org.eclipse.ptp.internal.rdt.core.model.Structure;
import org.eclipse.ptp.internal.rdt.core.model.StructureTemplate;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.TypeDef;
import org.eclipse.ptp.internal.rdt.core.model.Variable;

public class BindingAdapter {
    public static ICElement adaptBinding(ITranslationUnit unit, IBinding binding, int offset, int length, boolean definition) throws CModelException, DOMException {
        Parent parent = BindingAdapter.adaptParent(unit, binding);
        if (parent == null) {
            return null;
        }
        SourceManipulation element = null;
        if (binding instanceof ICPPMethod) {
            element = binding instanceof ICPPFunctionTemplate ? (definition ? new MethodTemplate(parent, (ICPPMethod)binding, (ICPPTemplateDefinition)binding) : new MethodTemplateDeclaration(parent, (ICPPMethod)binding, (ICPPTemplateDefinition)binding)) : (definition ? new Method(parent, (ICPPMethod)binding) : new MethodDeclaration(parent, (ICPPMethod)binding));
        } else if (binding instanceof IFunction) {
            element = binding instanceof ICPPFunctionTemplate ? (definition ? new FunctionTemplate(parent, (IFunction)binding, (ICPPTemplateDefinition)binding) : new FunctionTemplateDeclaration(parent, (IFunction)binding, (ICPPTemplateDefinition)binding)) : (binding instanceof ICPPFunctionTemplate ? (definition ? new FunctionTemplate(parent, (IFunction)binding, (ICPPTemplateDefinition)((ICPPFunctionTemplate)binding)) : new FunctionTemplateDeclaration(parent, (IFunction)binding, (ICPPTemplateDefinition)((ICPPFunctionTemplate)binding))) : (definition ? new Function(parent, (IFunction)binding) : new FunctionDeclaration(parent, (IFunction)binding)));
        } else if (binding instanceof IField) {
            element = new Field(parent, (IField)binding);
        } else if (binding instanceof IVariable) {
            if (binding instanceof IParameter) {
                return null;
            }
            element = new Variable(parent, (IVariable)binding);
        } else if (binding instanceof IEnumeration) {
            element = new Enumeration(parent, (IEnumeration)binding);
        } else if (binding instanceof IEnumerator) {
            element = new Enumerator(parent, (IEnumerator)binding);
        } else if (binding instanceof ICompositeType) {
            element = BindingAdapter.createHandleForComposite(parent, (ICompositeType)binding);
        } else if (binding instanceof ICPPNamespace) {
            element = new Namespace(parent, (ICPPNamespace)binding);
        } else if (binding instanceof ITypedef) {
            element = new TypeDef(parent, (ITypedef)binding);
        }
        if (element != null) {
            parent.addChild(element);
            if (unit != null) {
                SourceManipulation hml;
                element.setLocationURI(unit.getLocationURI());
                if (unit instanceof IHasManagedLocation) {
                    hml = element;
                    element.setManagedLocation(hml.getManagedLocation());
                }
                if (unit instanceof IHasRemotePath) {
                    hml = element;
                    element.setRemotePath(hml.getRemotePath());
                }
                element.setPath(unit.getPath());
            }
            element.setIdPos(offset, length);
            ICProject project = unit.getCProject();
            element.setCProject(project);
        }
        return element;
    }

    private static Parent adaptParent(ITranslationUnit tu, IBinding binding) throws DOMException {
        Parent grandParent;
        Parent parent;
        if (tu instanceof TranslationUnit) {
            parent = (Parent)tu;
        } else {
            if (tu == null) {
                throw new IllegalArgumentException();
            }
            parent = new TranslationUnit(null, tu);
        }
        IBinding parentBinding = binding.getOwner();
        if (parentBinding == null) {
            IScope scope = binding.getScope();
            if (scope != null && scope.getKind() == EScopeKind.eLocal) {
                return null;
            }
            return parent;
        }
        if (parentBinding instanceof IEnumeration) {
            grandParent = BindingAdapter.adaptParent(tu, parentBinding);
            if (parentBinding instanceof ICPPEnumeration && parentBinding.getNameCharArray().length > 0) {
                if (grandParent != null) {
                    return new Enumeration(grandParent, (IEnumeration)((ICPPEnumeration)parentBinding));
                }
            } else {
                return grandParent;
            }
        }
        if (parentBinding instanceof ICPPNamespace) {
            char[] scopeName = parentBinding.getNameCharArray();
            if (scopeName.length == 0) {
                return BindingAdapter.adaptParent(tu, parentBinding);
            }
            Parent grandParent2 = BindingAdapter.adaptParent(tu, parentBinding);
            if (grandParent2 == null) {
                return null;
            }
            return new Namespace(grandParent2, (ICPPNamespace)parentBinding);
        }
        if (parentBinding instanceof ICompositeType && (grandParent = BindingAdapter.adaptParent(tu, parentBinding)) != null) {
            return BindingAdapter.createHandleForComposite(grandParent, (ICompositeType)parentBinding);
        }
        return null;
    }

    public static ICElement adaptBinding(ITranslationUnit parent, IBinding binding, boolean definition) throws CModelException, DOMException {
        return BindingAdapter.adaptBinding(parent, binding, -1, -1, definition);
    }

    private static SourceManipulation createHandleForComposite(Parent parent, ICompositeType classBinding) throws DOMException {
        ICPPClassSpecialization spec;
        ICPPClassType orig;
        if (classBinding instanceof ICPPClassTemplatePartialSpecialization) {
            return new StructureTemplate(parent, (ICPPClassTemplatePartialSpecialization)classBinding);
        }
        if (classBinding instanceof ICPPClassTemplate) {
            return new StructureTemplate(parent, (ICPPClassTemplate)classBinding);
        }
        if (classBinding instanceof ICPPClassSpecialization && (orig = (spec = (ICPPClassSpecialization)classBinding).getSpecializedBinding()) instanceof ICPPClassTemplate) {
            return new StructureTemplate(parent, (ICompositeType)((ICPPClassSpecialization)classBinding), (ICPPTemplateDefinition)((ICPPClassTemplate)orig));
        }
        return new Structure(parent, classBinding);
    }
}

