/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.photran.internal.ui.actions.Messages;
import org.eclipse.rephraserengine.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;

public class DisplaySymbolTable
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                progressMonitor.beginTask(Messages.DisplaySymbolTable_WaitingForBackgroundWorkToComplete, -1);
                File temp = UIUtil.createTempFile();
                final PrintStream ps = UIUtil.createPrintStream((File)temp);
                ps.println("SYMBOL TABLE - Derived from Virtual Program Graph");
                this.getAST().accept((IASTVisitor)new GenericASTVisitor(){
                    private int indentation = 0;

                    public void visitASTNode(IASTNode node) {
                        if (!(node instanceof ScopingNode)) {
                            this.traverseChildren(node);
                            return;
                        }
                        if (node instanceof ASTExecutableProgramNode && node.getParent() != null) {
                            this.traverseChildren(node);
                            return;
                        }
                        ScopingNode scope = (ScopingNode)node;
                        ps.println();
                        this.describeScope(scope);
                        this.indentation += 4;
                        try {
                            for (Definition d : scope.getAllDefinitions()) {
                                this.println(DisplaySymbolTable.this.describeDeclaration(d));
                            }
                        }
                        catch (Exception e) {
                            this.println("EXCEPTION: " + e.getClass().getName() + ": " + e.getMessage());
                            e.printStackTrace(ps);
                        }
                        this.traverseChildren(node);
                        this.indentation -= 4;
                    }

                    private void describeScope(ScopingNode scope) {
                        ImplicitSpec implicitSpec;
                        PhotranTokenRef representativeToken = scope.getRepresentativeToken();
                        if (representativeToken.getOffset() < 0) {
                            this.print("(Global Scope)");
                        } else {
                            this.print("Scope: " + representativeToken.getText());
                        }
                        if (scope.isInternal()) {
                            ps.print(" (Internal Subprogram)");
                        }
                        if (scope.isDefaultVisibilityPrivate()) {
                            ps.print(" - Default Visibility is PRIVATE");
                        }
                        if ((implicitSpec = scope.getImplicitSpec()) == null) {
                            ps.print(" - Implicit None");
                        } else {
                            ps.print(" - " + implicitSpec.toString());
                        }
                        ps.println();
                    }

                    private void print(String text) {
                        int i = 0;
                        while (i < this.indentation) {
                            ps.print(' ');
                            ++i;
                        }
                        ps.print(text);
                    }

                    private void println(String text) {
                        this.print(text);
                        ps.println();
                    }
                });
                ps.close();
                UIUtil.openHtmlViewerOn((String)"Symbol Table", (File)temp);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

