/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.internal.ToolStep;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostlaunchTool
extends ToolStep
implements IToolLaunchConfigurationConstants {
    String outputLocation;
    String currentFile;
    FileFilter dFil = new DirFilter();
    private PostProcTool tool = null;
    boolean externalTarget = false;
    String projName = null;

    public PostlaunchTool(ILaunchConfiguration conf, PostProcTool ppTool, String outLoc) throws CoreException {
        super(conf, Messages.PostlaunchTool_Analysis);
        this.tool = ppTool;
        this.projectLocation = this.outputLocation = outLoc;
    }

    public void postlaunch(IProgressMonitor monitor) throws CoreException {
        if (this.tool.analysisCommands != null && this.tool.analysisCommands.length > 0) {
            File projectLoc = new File(this.outputLocation);
            int i = 0;
            while (i < this.tool.analysisCommands.length) {
                if (this.tool.analysisCommands[i].toolGroup == null || !this.tool.analysisCommands[i].toolGroup.equals("internal")) {
                    List<String> runTool = this.getToolCommandList(this.tool.analysisCommands[i], this.configuration);
                    if (this.tool.forAllLike != null) {
                        File getname = new File(this.currentFile);
                        String name = getname.getName();
                        if (name.contains(".")) {
                            name = name.substring(0, name.lastIndexOf("."));
                        }
                        int runDex = 0;
                        while (runDex < runTool.size()) {
                            String s = runTool.get(runDex);
                            s = s.replace("%%FILE%%", this.currentFile);
                            s = s.replace("%%FILENAME%%", name);
                            runTool.set(runDex, s);
                            ++runDex;
                        }
                    }
                    if (runTool != null) {
                        if (this.tool.analysisCommands[i].isVisualizer) {
                            BuildLaunchUtils.runVis(runTool, null, projectLoc);
                        } else {
                            BuildLaunchUtils.runTool(runTool, null, projectLoc, this.tool.analysisCommands[i].outToFile);
                        }
                    } else {
                        System.out.println(String.valueOf(Messages.PostlaunchTool_TheCommand) + this.tool.analysisCommands[i].toolCommand + Messages.PostlaunchTool_CouldNotRun);
                    }
                } else {
                    AbstractToolDataManager manager = Activator.getPerfDataManager(this.tool.analysisCommands[i].toolCommand);
                    if (manager != null) {
                        if (this.externalTarget) {
                            manager.setExternalTarget(true);
                        } else {
                            this.projName = this.thisCProject.getElementName();
                        }
                        manager.process(this.projName, this.configuration, this.outputLocation);
                    }
                }
                ++i;
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.tool == null) {
            return new Status(2, "com.ibm.jdg2e.concurrency", 0, Messages.PostlaunchTool_NoToolNoData, null);
        }
        if (this.outputLocation == null) {
            if (this.tool.useDefaultLocation) {
                this.outputLocation = System.getProperty("user.home");
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        if (s == null) {
                            s = PlatformUI.getWorkbench().getDisplay().getShells()[0];
                        }
                        DirectoryDialog dl = new DirectoryDialog(s);
                        dl.setText(Messages.PostlaunchTool_SelectPerfDir);
                        PostlaunchTool.this.outputLocation = dl.open();
                    }
                });
                if (this.outputLocation == null) {
                    return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.PostlaunchTool_NoData, null);
                }
                this.externalTarget = true;
            }
        }
        try {
            if (this.tool.forAllLike != null) {
                File workDir = new File(this.outputLocation);
                FilenameFilter ffn = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(((PostlaunchTool)PostlaunchTool.this).tool.forAllLike.toLowerCase());
                    }
                };
                LinkedHashSet<File> fileSet = new LinkedHashSet<File>();
                this.findFiles(fileSet, workDir, this.tool.depth, ffn);
                if (fileSet.size() <= 0) {
                    return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.PostlaunchTool_NoValidFiles, null);
                }
                for (File f : fileSet) {
                    this.currentFile = f.getCanonicalPath();
                    this.postlaunch(monitor);
                }
            } else {
                this.postlaunch(monitor);
            }
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.PostlaunchTool_DataCollectError, (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.PostlaunchTool_DataCollected, null);
    }

    private void findFiles(Set<File> fileSet, File root, int depth, FilenameFilter filter) {
        File[] files;
        File[] fileArray = files = root.listFiles(filter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            fileSet.add(f);
            ++n2;
        }
        if (depth > 0 || depth < 0) {
            File[] roots = root.listFiles(this.dFil);
            int i = 0;
            while (i < roots.length) {
                this.findFiles(fileSet, roots[i], depth - 1, filter);
                ++i;
            }
        }
    }

    class DirFilter
    implements FileFilter {
        DirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

