/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rephraserengine.core.refactorings.IEditorRefactoring;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPGLog;
import org.eclipse.rephraserengine.core.vpg.refactoring.Messages;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPGEditorRefactoring<A, T, V extends EclipseVPG<A, T, ? extends TokenRef<T>, ? extends VPGDB<A, T, ?, ?>, ? extends EclipseVPGLog<T, ?>>>
extends VPGRefactoring<A, T, V>
implements IEditorRefactoring {
    protected IFile fileInEditor;
    protected ITextSelection selectedRegionInEditor;
    protected A astOfFileInEditor;

    public void initialize(IFile file, ITextSelection selection) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cannot be null");
        }
        this.fileInEditor = file;
        this.selectedRegionInEditor = selection;
        this.astOfFileInEditor = null;
    }

    public void initialize(IFile file) {
        this.initialize(file, null);
    }

    @Override
    protected void checkFiles(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        assert (this.fileInEditor != null);
        this.checkIfFileIsAccessibleAndWritable(this.fileInEditor);
        this.astOfFileInEditor = this.vpg.acquireTransientAST(this.fileInEditor);
        this.logVPGErrors(status, this.fileInEditor);
        if (this.astOfFileInEditor == null) {
            this.fail(Messages.VPGEditorRefactoring_FileInTheEditorCannotBeParsed);
        }
    }
}

