/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.internal.core.parser.scanner.ASTFileLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTImageLocation;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectStyleMacro;

public abstract class ImageLocationInfo {
    public static final ImageLocationInfo[] NO_LOCATION_INFOS = new ImageLocationInfo[0];
    int fTokenOffsetInExpansion = -1;

    public abstract IASTImageLocation createLocation(LocationMap var1, ImageLocationInfo var2);

    public abstract boolean canConcatenate(ImageLocationInfo var1);

    public static class MacroImageLocationInfo
    extends ImageLocationInfo {
        private final ObjectStyleMacro fMacro;
        private final int fOffset;
        private final int fEndOffset;

        public MacroImageLocationInfo(ObjectStyleMacro macro, int offset, int endOffset) {
            this.fMacro = macro;
            this.fOffset = offset;
            this.fEndOffset = endOffset;
        }

        public IASTImageLocation createLocation(LocationMap lm, ImageLocationInfo upto) {
            IASTPreprocessorMacroDefinition md = lm.getMacroDefinition(this.fMacro);
            IASTFileLocation expansionLoc = md.getExpansionLocation();
            if (expansionLoc != null) {
                int length = ((MacroImageLocationInfo)upto).fEndOffset - this.fOffset;
                return new ASTImageLocation(2, expansionLoc.getFileName(), expansionLoc.getNodeOffset() + this.fOffset, length);
            }
            return null;
        }

        public boolean canConcatenate(ImageLocationInfo info) {
            if (info instanceof MacroImageLocationInfo) {
                MacroImageLocationInfo mli = (MacroImageLocationInfo)info;
                if (mli.fMacro == this.fMacro && this.fEndOffset <= mli.fOffset) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ParameterImageLocationInfo
    extends ImageLocationInfo {
        public int fSequenceNumber;
        public int fSequenceEndNumber;

        public ParameterImageLocationInfo(int sequenceNumber, int sequenceEndNumber) {
            this.fSequenceNumber = sequenceNumber;
            this.fSequenceEndNumber = sequenceEndNumber;
        }

        public IASTImageLocation createLocation(LocationMap lm, ImageLocationInfo upto) {
            int sequenceEnd = ((ParameterImageLocationInfo)upto).fSequenceEndNumber;
            ASTFileLocation loc = lm.getMappedFileLocation(this.fSequenceNumber, sequenceEnd - this.fSequenceNumber);
            if (loc != null) {
                return new ASTImageLocation(3, loc.getFileName(), loc.getNodeOffset(), loc.getNodeLength());
            }
            return null;
        }

        public boolean canConcatenate(ImageLocationInfo info) {
            if (info instanceof ParameterImageLocationInfo) {
                ParameterImageLocationInfo pli = (ParameterImageLocationInfo)info;
                if (this.fSequenceEndNumber <= pli.fSequenceNumber) {
                    return true;
                }
            }
            return false;
        }
    }
}

