/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.rm.core.RMPreferenceConstants;
import org.eclipse.ptp.rm.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractRemoteRMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
RMPreferenceConstants {
    public static final String EMPTY_STRING = "";
    private String serverFile = "";
    private boolean loading = true;
    protected Button fNoneButton = null;
    protected Button fPortForwardingButton = null;
    protected Button fManualButton = null;
    protected WidgetListener listener = new WidgetListener();

    public void dispose() {
        super.dispose();
    }

    public abstract Preferences getPreferences();

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.loadDefaults();
        this.updateApplyButton();
    }

    public boolean performOk() {
        Preferences preferences = this.getPreferences();
        int options = 0;
        if (this.fPortForwardingButton.getSelection()) {
            options |= 2;
        }
        if (this.fManualButton.getSelection()) {
            options |= 4;
        }
        preferences.setValue("OPTIONS", options);
        this.savePreferences();
        return true;
    }

    public abstract void savePreferences();

    private void updateOptions(int options) {
        this.fPortForwardingButton.setSelection(false);
        this.fNoneButton.setSelection(true);
        if ((options & 2) == 2) {
            this.fPortForwardingButton.setSelection(true);
            this.fNoneButton.setSelection(false);
        }
        this.fManualButton.setSelection((options & 4) == 4);
    }

    private void loadSaved() {
        this.loading = true;
        Preferences preferences = this.getPreferences();
        this.updateOptions(preferences.getInt("OPTIONS"));
        this.loading = false;
    }

    private void loadDefaults() {
        this.loading = true;
        Preferences preferences = this.getPreferences();
        this.updateOptions(preferences.getDefaultInt("OPTIONS"));
        this.loading = false;
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    private Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        Group mxGroup = new Group(composite, 16);
        mxGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        mxGroup.setLayoutData((Object)this.spanGridData(768, 2));
        mxGroup.setText(Messages.AbstractRemotePreferencePage_4);
        this.fNoneButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemotePreferencePage_5, "mxGroup", (SelectionListener)this.listener);
        this.fPortForwardingButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemotePreferencePage_6, "mxGroup", (SelectionListener)this.listener);
        Group otherGroup = new Group(composite, 16);
        otherGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        otherGroup.setLayoutData((Object)this.spanGridData(768, 2));
        otherGroup.setText(Messages.AbstractRemotePreferencePage_8);
        this.fManualButton = this.createCheckButton((Composite)otherGroup, Messages.AbstractRemotePreferencePage_9);
        this.loadSaved();
        return composite;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected void defaultSetting() {
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected void handlePathBrowseButtonSelected() {
    }

    protected boolean isValidSetting() {
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidSetting()) {
            return;
        }
        this.setValid(true);
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            evt.getSource();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AbstractRemoteRMPreferencePage.this.updatePreferencePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            e.getSource();
            AbstractRemoteRMPreferencePage.this.fManualButton.setEnabled(true);
            AbstractRemoteRMPreferencePage.this.updatePreferencePage();
        }
    }
}

