/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranAST;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

public class Reindenter {
    private final IFortranAST ast;
    private final int lineNumOfLastTokenInAST;

    public static void reindent(IASTNode node, IFortranAST ast) {
        new Reindenter(node, ast, Strategy.SHIFT_ENTIRE_BLOCK);
    }

    public static void reindent(Token firstTokenInAffectedNode, Token lastTokenInAffectedNode, IFortranAST ast) {
        new Reindenter(firstTokenInAffectedNode, lastTokenInAffectedNode, ast, Strategy.SHIFT_ENTIRE_BLOCK);
    }

    public static void reindent(int fromLine, int thruLine, IFortranAST ast) {
        new Reindenter(fromLine, thruLine, ast, Strategy.SHIFT_ENTIRE_BLOCK);
    }

    public static void reindent(IASTNode node, IFortranAST ast, Strategy strategy) {
        new Reindenter(node, ast, strategy);
    }

    public static void reindent(Token firstTokenInAffectedNode, Token lastTokenInAffectedNode, IFortranAST ast, Strategy strategy) {
        new Reindenter(firstTokenInAffectedNode, lastTokenInAffectedNode, ast, strategy);
    }

    public static void reindent(int fromLine, int thruLine, IFortranAST ast, Strategy strategy) {
        new Reindenter(fromLine, thruLine, ast, strategy);
    }

    private Reindenter(IASTNode node, IFortranAST ast, Strategy strategy) {
        this(node.findFirstToken(), node.findLastToken(), ast, strategy);
    }

    private Reindenter(int fromLine, int thruLine, IFortranAST ast, Strategy strategy) {
        this(ast.findFirstTokenOnLine(fromLine), ast.findLastTokenOnLine(thruLine), ast, strategy);
    }

    private Reindenter(Token firstTokenInRegion, Token lastTokenInRegion, IFortranAST ast, Strategy strategy) {
        this.lineNumOfLastTokenInAST = this.recomputeLineColInfo(ast);
        this.ast = new FortranAST(ast.getFile(), ast.getRoot(), new TokenList(ast.getRoot()));
        if (firstTokenInRegion != null && lastTokenInRegion != null) {
            ast.accept(strategy.createVisitor(this, firstTokenInRegion, lastTokenInRegion));
        }
    }

    private int recomputeLineColInfo(IFortranAST ast) {
        LineColComputer lcc = new LineColComputer(PhotranVPG.getInstance().getIFileCorrespondingTo(ast));
        ast.getRoot().accept(lcc);
        return lcc.line;
    }

    private String getIndentation(Token token) {
        int lastCR;
        String indent;
        String string = indent = token == null ? "" : token.getWhiteBefore();
        if (indent == null) {
            indent = "";
        }
        if ((lastCR = indent.lastIndexOf(10)) >= 0) {
            indent = indent.substring(lastCR + 1);
        }
        return indent;
    }

    private Token findTokenStartingFirstNonemptyLineBelow(int startLine) {
        int line = startLine + 1;
        while (line <= this.lineNumOfLastTokenInAST) {
            Token firstBlockOnLine = this.ast.findFirstTokenOnLine(line);
            if (firstBlockOnLine != null) {
                return firstBlockOnLine;
            }
            ++line;
        }
        return null;
    }

    private Token findTokenStartingLastNonemptyLineAbove(int startLine) {
        int line = startLine - 1;
        while (line >= 0) {
            Token firstBlockOnLine = this.ast.findFirstTokenOnLine(line);
            if (firstBlockOnLine != null) {
                return firstBlockOnLine;
            }
            --line;
        }
        return null;
    }

    private boolean startsIndentedRegion(Token token) {
        if (token == null) {
            return false;
        }
        Terminal t = token.getTerminal();
        return t == Terminal.T_PROGRAM || t == Terminal.T_FUNCTION || t == Terminal.T_SUBROUTINE || t == Terminal.T_MODULE || t == Terminal.T_BLOCK || t == Terminal.T_BLOCKDATA || t == Terminal.T_FORALL || t == Terminal.T_WHERE || t == Terminal.T_ELSE || t == Terminal.T_ELSEWHERE || t == Terminal.T_IF || t == Terminal.T_ELSEIF || t == Terminal.T_SELECTCASE || t == Terminal.T_SELECT || t == Terminal.T_CASE || t == Terminal.T_DO || t == Terminal.T_INTERFACE || t == Terminal.T_CONTAINS || t == Terminal.T_ASSOCIATE;
    }

    private boolean endsIndentedRegion(Token token) {
        if (token == null) {
            return false;
        }
        Terminal t = token.getTerminal();
        return t == Terminal.T_END || t == Terminal.T_ENDBLOCK || t == Terminal.T_ENDBLOCKDATA || t == Terminal.T_ENDDO || t == Terminal.T_ENDFILE || t == Terminal.T_ENDFORALL || t == Terminal.T_ENDFUNCTION || t == Terminal.T_ENDIF || t == Terminal.T_ENDINTERFACE || t == Terminal.T_ENDMODULE || t == Terminal.T_ENDPROGRAM || t == Terminal.T_ENDSELECT || t == Terminal.T_ENDSUBROUTINE || t == Terminal.T_ENDTYPE || t == Terminal.T_ENDWHERE || t == Terminal.T_ELSE || t == Terminal.T_ELSEWHERE || t == Terminal.T_ELSEIF || t == Terminal.T_CONTAINS;
    }

    private final class LineColComputer
    extends ASTVisitorWithLoops {
        private IFile file;
        private int fileOffset = 0;
        private int line = 1;
        private int col = 1;
        private IPreprocessorReplacement lastPreprocRepl = null;

        public LineColComputer(IFile file) {
            this.file = file;
        }

        public void visitToken(Token token) {
            IPreprocessorReplacement thisPreprocRepl = token.getPreprocessorDirective();
            if (thisPreprocRepl != this.lastPreprocRepl) {
                if (thisPreprocRepl != null) {
                    this.consider(token.getWhiteBefore());
                    token.setFileOffset(this.fileOffset);
                    token.setLine(this.line);
                    token.setCol(this.col);
                    this.consider(thisPreprocRepl.toString());
                }
                this.lastPreprocRepl = thisPreprocRepl;
            }
            if (thisPreprocRepl == null) {
                this.consider(token.getWhiteBefore());
                token.setFileOffset(this.fileOffset);
                token.setLine(this.line);
                token.setCol(this.col);
                this.consider(token.getText());
                this.consider(token.getWhiteAfter());
            }
        }

        private void consider(String s) {
            int i = 0;
            int len = s.length();
            while (i < len) {
                ++this.fileOffset;
                if (s.charAt(i) == '\n') {
                    ++this.line;
                    this.col = 1;
                } else {
                    ++this.col;
                }
                ++i;
            }
        }
    }

    private final class ReindentEachLineReindentingVisitor
    extends ReindentingVisitor {
        private Token firstTokenOnPreviousLine;
        private String indentationOfPreviousLine;

        protected ReindentEachLineReindentingVisitor(Token firstTokenInRegion, Token lastTokenInRegion) {
            super(firstTokenInRegion, lastTokenInRegion);
            int firstLineNumToReindent = firstTokenInRegion.getLine();
            Token firstTokenOnFirstLineToAdjust = Reindenter.this.ast.findFirstTokenOnLine(firstLineNumToReindent);
            if (firstTokenOnFirstLineToAdjust != firstTokenInRegion) {
                ++firstLineNumToReindent;
            }
            this.firstTokenOnPreviousLine = Reindenter.this.findTokenStartingLastNonemptyLineAbove(firstTokenInRegion.getLine());
            this.removeIndent = this.indentationOfPreviousLine = Reindenter.this.getIndentation(this.firstTokenOnPreviousLine);
            this.addIndent = Reindenter.this.getIndentation(firstTokenOnFirstLineToAdjust);
        }

        protected void updateIndentation(Token firstTokenOnLine) {
            String currentIndentation;
            String whiteBeforeFirstTok = firstTokenOnLine.getWhiteBefore();
            if (!whiteBeforeFirstTok.endsWith(currentIndentation = Reindenter.this.getIndentation(firstTokenOnLine))) {
                return;
            }
            String comments = whiteBeforeFirstTok.substring(0, whiteBeforeFirstTok.length() - currentIndentation.length());
            this.removeIndent = currentIndentation;
            this.addIndent = this.indentationOfPreviousLine;
            if (Reindenter.this.startsIndentedRegion(this.firstTokenOnPreviousLine)) {
                this.addIndent = String.valueOf(this.addIndent) + "    ";
            } else if (Reindenter.this.endsIndentedRegion(firstTokenOnLine) && this.addIndent.endsWith("    ")) {
                this.addIndent = this.addIndent.substring(0, this.addIndent.length() - 4);
            }
            firstTokenOnLine.setWhiteBefore(String.valueOf(this.reindentedComments(comments)) + this.newIndentation(currentIndentation));
            this.firstTokenOnPreviousLine = firstTokenOnLine;
            this.indentationOfPreviousLine = this.addIndent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ReindentingVisitor
    extends ASTVisitorWithLoops {
        protected final Token firstTokenInRegion;
        protected final Token lastTokenInRegion;
        protected String removeIndent;
        protected String addIndent;
        protected boolean inFormatRegion = false;
        protected Token previousToken = null;

        protected ReindentingVisitor(Token firstTokenInRegion, Token lastTokenInRegion) {
            this.lastTokenInRegion = lastTokenInRegion;
            this.firstTokenInRegion = firstTokenInRegion;
        }

        @Override
        public void visitToken(Token token) {
            if (token == this.firstTokenInRegion) {
                this.inFormatRegion = true;
            } else if (token == this.lastTokenInRegion) {
                this.inFormatRegion = false;
            }
            if (this.inFormatRegion && (this.previousToken == null || token.getLine() > this.previousToken.getLine())) {
                this.updateIndentation(token);
            }
            this.previousToken = token;
        }

        protected abstract void updateIndentation(Token var1);

        protected String reindentedComments(String comments) {
            StringBuilder sb = new StringBuilder();
            for (String line : this.splitLines(comments)) {
                sb.append(this.reindentComment(line));
            }
            return sb.toString();
        }

        private ArrayList<String> splitLines(String comments) {
            ArrayList<String> result = new ArrayList<String>();
            int start = 0;
            int end = comments.indexOf(10, start);
            while (end > start) {
                result.add(comments.substring(start, end + 1));
                start = end + 1;
                end = comments.indexOf(10, start);
            }
            if (comments.length() > start) {
                result.add(comments.substring(start, comments.length()));
            }
            return result;
        }

        private String reindentComment(String line) {
            if (line.trim().equals("")) {
                return line;
            }
            int endIndex = 0;
            while (endIndex < line.length() && (line.charAt(endIndex) == ' ' || line.charAt(endIndex) == '\t')) {
                ++endIndex;
            }
            String indentation = line.substring(0, endIndex);
            String comment = line.substring(endIndex);
            return String.valueOf(this.newIndentation(indentation)) + comment;
        }

        protected String newIndentation(String currentIndentation) {
            String newIndentation = currentIndentation.startsWith(this.removeIndent) ? currentIndentation.substring(this.removeIndent.length()) : currentIndentation;
            newIndentation = String.valueOf(newIndentation) + this.addIndent;
            return newIndentation;
        }
    }

    private final class ShiftBlockReindentingVisitor
    extends ReindentingVisitor {
        protected ShiftBlockReindentingVisitor(Token firstTokenInRegion, Token lastTokenInRegion) {
            super(firstTokenInRegion, lastTokenInRegion);
            int firstLineNumToReindent = firstTokenInRegion.getLine();
            Token firstTokenOnFirstLineToAdjust = Reindenter.this.ast.findFirstTokenOnLine(firstLineNumToReindent);
            if (firstTokenOnFirstLineToAdjust != firstTokenInRegion) {
                ++firstLineNumToReindent;
            }
            Token firstTokenOnLineAfterReindentedRegion = Reindenter.this.findTokenStartingFirstNonemptyLineBelow(lastTokenInRegion.getLine());
            this.removeIndent = Reindenter.this.getIndentation(firstTokenOnFirstLineToAdjust);
            this.addIndent = Reindenter.this.getIndentation(firstTokenOnLineAfterReindentedRegion);
            if (Reindenter.this.endsIndentedRegion(firstTokenOnLineAfterReindentedRegion)) {
                Token firstTokenOnLineAboveReindentedRegion = Reindenter.this.findTokenStartingLastNonemptyLineAbove(firstTokenInRegion.getLine());
                this.addIndent = firstTokenOnLineAboveReindentedRegion != null && !Reindenter.this.startsIndentedRegion(firstTokenOnLineAboveReindentedRegion) ? Reindenter.this.getIndentation(firstTokenOnLineAboveReindentedRegion) : String.valueOf(this.addIndent) + "    ";
            }
        }

        protected void updateIndentation(Token firstTokenOnLine) {
            String currentIndentation;
            String whiteBeforeFirstTok = firstTokenOnLine.getWhiteBefore();
            if (!whiteBeforeFirstTok.endsWith(currentIndentation = Reindenter.this.getIndentation(firstTokenOnLine))) {
                return;
            }
            String comments = whiteBeforeFirstTok.substring(0, whiteBeforeFirstTok.length() - currentIndentation.length());
            firstTokenOnLine.setWhiteBefore(String.valueOf(this.reindentedComments(comments)) + this.newIndentation(currentIndentation));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        SHIFT_ENTIRE_BLOCK{

            protected ReindentingVisitor createVisitor(Reindenter reindenter, Token firstTokenInRegion, Token lastTokenInRegion) {
                Reindenter reindenter2 = reindenter;
                reindenter2.getClass();
                return reindenter2.new ShiftBlockReindentingVisitor(firstTokenInRegion, lastTokenInRegion);
            }
        }
        ,
        REINDENT_EACH_LINE{

            protected ReindentingVisitor createVisitor(Reindenter reindenter, Token firstTokenInRegion, Token lastTokenInRegion) {
                Reindenter reindenter2 = reindenter;
                reindenter2.getClass();
                return reindenter2.new ReindentEachLineReindentingVisitor(firstTokenInRegion, lastTokenInRegion);
            }
        };


        protected abstract ReindentingVisitor createVisitor(Reindenter var1, Token var2, Token var3);
    }
}

