/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSelector;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner.ISkippedIndexedFilesListener;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.core.runtime.CoreException;

public abstract class ASTTranslationUnit
extends ASTNode
implements IASTTranslationUnit,
ISkippedIndexedFilesListener {
    private static final IASTPreprocessorStatement[] EMPTY_PREPROCESSOR_STATEMENT_ARRAY = new IASTPreprocessorStatement[0];
    private static final IASTPreprocessorMacroDefinition[] EMPTY_PREPROCESSOR_MACRODEF_ARRAY = new IASTPreprocessorMacroDefinition[0];
    private static final IASTPreprocessorIncludeStatement[] EMPTY_PREPROCESSOR_INCLUSION_ARRAY = new IASTPreprocessorIncludeStatement[0];
    private static final IASTProblem[] EMPTY_PROBLEM_ARRAY = new IASTProblem[0];
    private static final String EMPTY_STRING = "";
    private IASTDeclaration[] fAllDeclarations = null;
    private IASTDeclaration[] fActiveDeclarations = null;
    private int fLastDeclaration = -1;
    protected ILocationResolver fLocationResolver;
    private IIndex fIndex;
    private boolean fIsHeader = true;
    private IIndexFileSet fIndexFileSet;
    private INodeFactory fNodeFactory;
    private boolean fForContentAssist;

    public final IASTTranslationUnit getTranslationUnit() {
        return this;
    }

    public final void addDeclaration(IASTDeclaration d) {
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(OWNED_DECLARATION);
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.fAllDeclarations, ++this.fLastDeclaration, d);
            this.fActiveDeclarations = null;
        }
    }

    public final IASTDeclaration[] getDeclarations() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fLastDeclaration + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, this.fAllDeclarations, this.fLastDeclaration);
            return this.fAllDeclarations;
        }
        return this.getDeclarations();
    }

    public final void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fLastDeclaration) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
    }

    public final IName[] getDeclarations(IBinding binding) {
        IName[] names = this.getDeclarationsInAST(binding);
        if (names.length == 0 && this.fIndex != null) {
            try {
                names = this.fIndex.findDeclarations(binding);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return names;
            }
        }
        return names;
    }

    protected final IASTName[] getMacroDefinitionsInAST(IMacroBinding binding) {
        if (this.fLocationResolver == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        return this.fLocationResolver.getDeclarations(binding);
    }

    protected final IASTName[] getMacroReferencesInAST(IMacroBinding binding) {
        if (this.fLocationResolver == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        return this.fLocationResolver.getReferences(binding);
    }

    public final IName[] getDefinitions(IBinding binding) {
        IName[] names = this.getDefinitionsInAST(binding);
        if (names.length == 0 && this.fIndex != null) {
            try {
                names = this.fIndex.findDefinitions(binding);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return names;
            }
        }
        return names;
    }

    public final IASTPreprocessorMacroDefinition[] getMacroDefinitions() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_MACRODEF_ARRAY;
        }
        return this.fLocationResolver.getMacroDefinitions();
    }

    public IASTPreprocessorMacroExpansion[] getMacroExpansions() {
        if (this.fLocationResolver == null) {
            return IASTPreprocessorMacroExpansion.EMPTY_ARRAY;
        }
        return this.fLocationResolver.getMacroExpansions(this.getFileLocation());
    }

    public final IASTPreprocessorMacroDefinition[] getBuiltinMacroDefinitions() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_MACRODEF_ARRAY;
        }
        return this.fLocationResolver.getBuiltinMacroDefinitions();
    }

    public final IASTPreprocessorIncludeStatement[] getIncludeDirectives() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_INCLUSION_ARRAY;
        }
        return this.fLocationResolver.getIncludeDirectives();
    }

    public final IASTPreprocessorStatement[] getAllPreprocessorStatements() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_STATEMENT_ARRAY;
        }
        return this.fLocationResolver.getAllPreprocessorStatements();
    }

    public final void setLocationResolver(ILocationResolver resolver) {
        this.fLocationResolver = resolver;
        resolver.setRootNode(this);
    }

    public final IASTProblem[] getPreprocessorProblems() {
        if (this.fLocationResolver == null) {
            return EMPTY_PROBLEM_ARRAY;
        }
        IASTProblem[] result = this.fLocationResolver.getScannerProblems();
        int i = 0;
        while (i < result.length) {
            IASTProblem p = result[i];
            p.setParent(this);
            p.setPropertyInParent(IASTTranslationUnit.SCANNER_PROBLEM);
            ++i;
        }
        return result;
    }

    public final int getPreprocessorProblemsCount() {
        return this.fLocationResolver == null ? 0 : this.fLocationResolver.getScannerProblemsCount();
    }

    public final String getFilePath() {
        if (this.fLocationResolver == null) {
            return EMPTY_STRING;
        }
        return new String(this.fLocationResolver.getTranslationUnitPath());
    }

    public final boolean accept(ASTVisitor action) {
        IASTDeclaration[] decls;
        if (action.shouldVisitTranslationUnit) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTDeclaration[] iASTDeclarationArray = decls = this.getDeclarations(action.includeInactiveNodes);
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (!decl.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitTranslationUnit || action.leave(this) != 2;
    }

    public final IASTFileLocation flattenLocationsToFile(IASTNodeLocation[] nodeLocations) {
        if (this.fLocationResolver == null) {
            return null;
        }
        return this.fLocationResolver.flattenLocations(nodeLocations);
    }

    public final IASTTranslationUnit.IDependencyTree getDependencyTree() {
        if (this.fLocationResolver == null) {
            return null;
        }
        return this.fLocationResolver.getDependencyTree();
    }

    public final String getContainingFilename(int offset) {
        if (this.fLocationResolver == null) {
            return EMPTY_STRING;
        }
        return this.fLocationResolver.getContainingFilePath(offset);
    }

    public final IIndex getIndex() {
        return this.fIndex;
    }

    public final void setIndex(IIndex index) {
        this.fIndex = index;
        if (index != null) {
            this.fIndexFileSet = index.createFileSet();
        }
    }

    public final INodeFactory getASTNodeFactory() {
        return this.fNodeFactory;
    }

    public final void setASTNodeFactory(INodeFactory nodeFactory) {
        this.fNodeFactory = nodeFactory;
    }

    public final IASTComment[] getComments() {
        if (this.fLocationResolver != null) {
            return this.fLocationResolver.getComments();
        }
        return new IASTComment[0];
    }

    public final Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.fLocationResolver.getClass())) {
            return this.fLocationResolver;
        }
        if (adapter.isAssignableFrom(IIndexFileSet.class)) {
            return this.fIndexFileSet;
        }
        if (adapter.isAssignableFrom(Lexer.LexerOptions.class)) {
            return this.fLocationResolver.getLexerOptions();
        }
        return null;
    }

    public final boolean isHeaderUnit() {
        return this.fIsHeader;
    }

    public final void setIsHeaderUnit(boolean headerUnit) {
        this.fIsHeader = headerUnit;
    }

    public boolean isForContentAssist() {
        return this.fForContentAssist;
    }

    public final void setIsForContentAssist(boolean forContentAssist) {
        this.fForContentAssist = forContentAssist;
    }

    public void skippedFile(int offset, InternalFileContent fileContent) {
        if (this.fIndexFileSet != null) {
            List<IIndexFile> files = fileContent.getFilesIncluded();
            for (IIndexFile indexFile : files) {
                this.fIndexFileSet.add(indexFile);
            }
        }
    }

    public final IIndexFileSet getIndexFileSet() {
        return this.fIndexFileSet;
    }

    public final IASTNode selectNodeForLocation(String path, int realOffset, int realLength) {
        return this.getNodeSelector(path).findNode(realOffset, realLength);
    }

    public final IASTNodeSelector getNodeSelector(String filePath) {
        return new ASTNodeSelector(this, this.fLocationResolver, filePath);
    }

    public abstract void resolveAmbiguities();

    protected void copyAbstractTU(ASTTranslationUnit copy) {
        copy.setIndex(this.fIndex);
        copy.setIsHeaderUnit(this.fIsHeader);
        copy.setASTNodeFactory(this.fNodeFactory);
        copy.setLocationResolver(this.fLocationResolver);
        copy.setIsForContentAssist(this.fForContentAssist);
        IASTDeclaration[] iASTDeclarationArray = this.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            copy.addDeclaration(declaration == null ? null : declaration.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
    }

    public final void freeze() {
        this.accept(new ASTGenericVisitor(true){

            protected int genericVisit(IASTNode node) {
                ((ASTNode)node).setIsFrozen();
                return 3;
            }
        });
    }
}

