/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTBaseSpecifier
extends ASTNode
implements ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier,
IASTCompletionContext {
    private boolean isVirtual;
    private int visibility;
    private IASTName name;
    private boolean fIsPackExpansion;

    public CPPASTBaseSpecifier() {
    }

    public CPPASTBaseSpecifier(IASTName name) {
        this.setName(name);
    }

    public CPPASTBaseSpecifier(IASTName name, int visibility, boolean isVirtual) {
        this.isVirtual = isVirtual;
        this.visibility = visibility;
        this.setName(name);
    }

    public CPPASTBaseSpecifier copy() {
        CPPASTBaseSpecifier copy = new CPPASTBaseSpecifier(this.name == null ? null : this.name.copy());
        copy.isVirtual = this.isVirtual;
        copy.visibility = this.visibility;
        copy.fIsPackExpansion = this.fIsPackExpansion;
        copy.setOffsetAndLength(this);
        return copy;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean value) {
        this.assertNotFrozen();
        this.isVirtual = value;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int visibility) {
        this.assertNotFrozen();
        this.visibility = visibility;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitBaseSpecifiers && action instanceof ICPPASTVisitor) {
            switch (((ICPPASTVisitor)((Object)action)).visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitBaseSpecifiers && action instanceof ICPPASTVisitor) {
            switch (((ICPPASTVisitor)((Object)action)).leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 1;
        }
        return 3;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IASTName className;
        IBinding binding;
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ArrayList<ICPPClassType> filtered = new ArrayList<ICPPClassType>();
        ICPPClassType classType = null;
        if (this.getParent() instanceof CPPASTCompositeTypeSpecifier && (binding = (className = ((CPPASTCompositeTypeSpecifier)this.getParent()).getName()).resolveBinding()) instanceof ICPPClassType) {
            classType = (ICPPClassType)binding;
        }
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding binding2 = iBindingArray[n3];
            if (binding2 instanceof ICPPClassType) {
                ICPPClassType base = (ICPPClassType)binding2;
                try {
                    int key = base.getKey();
                    if (!(key != 3 || classType != null && base.isSameType(classType))) {
                        filtered.add(base);
                    }
                }
                catch (DOMException dOMException) {}
            }
            ++n3;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }
}

