/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IFunctionTemplate;
import org.eclipse.cdt.core.model.IFunctionTemplateDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IMethodTemplate;
import org.eclipse.cdt.core.model.IMethodTemplateDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.IStructureTemplateDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.CElement;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.Enumeration;
import org.eclipse.ptp.internal.rdt.core.model.Enumerator;
import org.eclipse.ptp.internal.rdt.core.model.Field;
import org.eclipse.ptp.internal.rdt.core.model.Function;
import org.eclipse.ptp.internal.rdt.core.model.FunctionDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.FunctionTemplate;
import org.eclipse.ptp.internal.rdt.core.model.FunctionTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.IHasManagedLocation;
import org.eclipse.ptp.internal.rdt.core.model.IHasRemotePath;
import org.eclipse.ptp.internal.rdt.core.model.Include;
import org.eclipse.ptp.internal.rdt.core.model.Macro;
import org.eclipse.ptp.internal.rdt.core.model.Method;
import org.eclipse.ptp.internal.rdt.core.model.MethodDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.MethodTemplate;
import org.eclipse.ptp.internal.rdt.core.model.MethodTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.Namespace;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.Structure;
import org.eclipse.ptp.internal.rdt.core.model.StructureDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.StructureTemplate;
import org.eclipse.ptp.internal.rdt.core.model.StructureTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.TypeDef;
import org.eclipse.ptp.internal.rdt.core.model.Using;
import org.eclipse.ptp.internal.rdt.core.model.Variable;
import org.eclipse.ptp.internal.rdt.core.model.VariableDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.VariableTemplate;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAdapter {
    public static <T extends ICElement> T adaptElement(Parent parent, T element, int depth, boolean adaptAncestors) throws CModelException {
        Object hml;
        ICProject project;
        Parent result;
        if (parent == null && adaptAncestors) {
            parent = ModelAdapter.adaptAncestors(element);
        }
        switch (element.getElementType()) {
            case 63: {
                result = new Enumeration(parent, (IEnumeration)element);
                break;
            }
            case 81: {
                result = new Enumerator(parent, (IEnumerator)element);
                break;
            }
            case 72: {
                result = new Field(parent, (IField)element);
                break;
            }
            case 74: {
                result = new Function(parent, (IFunction)element);
                break;
            }
            case 73: {
                result = new FunctionDeclaration(parent, (IFunctionDeclaration)element);
                break;
            }
            case 75: {
                result = new Include(parent, (IInclude)element);
                break;
            }
            case 79: {
                result = new Macro(parent, (IMacro)element);
                break;
            }
            case 70: {
                result = new Method(parent, (IMethod)element);
                break;
            }
            case 71: {
                result = new MethodDeclaration(parent, (IMethodDeclaration)element);
                break;
            }
            case 61: {
                result = new Namespace(parent, (INamespace)element);
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                result = new Structure(parent, (IStructure)element);
                break;
            }
            case 64: 
            case 66: 
            case 68: {
                result = new StructureDeclaration(parent, (IStructureDeclaration)element);
                break;
            }
            case 83: 
            case 85: 
            case 87: {
                result = new StructureTemplate(parent, (IStructureTemplate)element);
                break;
            }
            case 82: 
            case 84: 
            case 86: {
                result = new StructureTemplateDeclaration(parent, (IStructureTemplateDeclaration)element);
                break;
            }
            case 89: {
                result = new FunctionTemplate(parent, (IFunctionTemplate)element);
                break;
            }
            case 88: {
                result = new FunctionTemplateDeclaration(parent, (IFunctionTemplateDeclaration)element);
                break;
            }
            case 91: {
                result = new MethodTemplate(parent, (IMethodTemplate)element);
                break;
            }
            case 90: {
                result = new MethodTemplateDeclaration(parent, (IMethodTemplateDeclaration)element);
                break;
            }
            case 92: {
                result = new VariableTemplate(parent, (IVariable)element);
                break;
            }
            case 80: {
                result = new TypeDef(parent, (ITypeDef)element);
                break;
            }
            case 62: {
                result = new Using(parent, (IUsing)element);
                break;
            }
            case 76: {
                result = new Variable(parent, (IVariable)element);
                break;
            }
            case 77: {
                result = new VariableDeclaration(parent, (IVariableDeclaration)element);
                break;
            }
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                if (tu.isWorkingCopy()) {
                    result = new WorkingCopy(parent, tu, tu.getContents());
                    break;
                }
                result = new TranslationUnit(parent, tu);
                break;
            }
            case 11: {
                result = new CProject(element.getElementName());
                break;
            }
            default: {
                return null;
            }
        }
        if (parent != null) {
            parent.addChild(result);
        }
        if ((project = element.getCProject()) != null) {
            result.setCProject(new CProject(project.getElementName()));
        }
        result.setLocationURI(element.getLocationURI());
        if (element instanceof IHasManagedLocation) {
            hml = (IHasManagedLocation)element;
            result.setManagedLocation(hml.getManagedLocation());
        }
        if (element instanceof IHasRemotePath) {
            hml = (IHasRemotePath)element;
            result.setRemotePath(hml.getRemotePath());
        }
        result.setPath(element.getPath());
        if (depth != 0) {
            for (ICElement child : result.internalGetChildren()) {
                result.addChild((CElement)ModelAdapter.adaptElement(result, child, depth - 1, adaptAncestors));
            }
        }
        return (T)result;
    }

    static Parent adaptAncestors(ICElement element) throws CModelException {
        LinkedList<ICElement> ancestors = new LinkedList<ICElement>();
        ICElement current = element.getParent();
        while (current != null) {
            ancestors.addFirst(current);
            current = current.getParent();
        }
        Parent parent = null;
        for (ICElement ancestor : ancestors) {
            ICElement adapted = ModelAdapter.adaptElement(parent, ancestor, 0, false);
            if (!(adapted instanceof Parent)) continue;
            parent = (Parent)adapted;
        }
        return parent;
    }
}

