/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.internal.core.index.IndexBasedFileContentProvider;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInputAdapter;
import org.eclipse.ptp.internal.rdt.core.RemoteUtil;
import org.eclipse.ptp.internal.rdt.core.miners.CDTMiner;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLanguageMapper;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.IHasManagedLocation;
import org.eclipse.ptp.internal.rdt.core.model.IHasRemotePath;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.Path;
import org.eclipse.ptp.rdt.core.IConfigurableLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationUnit
extends Parent
implements ITranslationUnit {
    private static final long serialVersionUID = 1L;
    private String fLanguageId;
    protected transient ILanguage fLanguage;
    private IScannerInfo fScannerInfo;
    private Map<String, String> fLanguageProperties;
    private boolean isHeaderUnit = false;

    public TranslationUnit(ICElement parent, String name, String projectName, URI locationURI) {
        super(parent, 60, name);
        if (projectName == null || locationURI == null) {
            throw new IllegalArgumentException();
        }
        this.setCProject(new CProject(projectName));
        this.fLocation = locationURI;
    }

    public TranslationUnit(Parent parent, ITranslationUnit element) {
        super(parent, element.getElementType(), element.getElementName());
        ICProject project = element.getCProject();
        if (project instanceof CProject) {
            this.setCProject(project);
        } else if (project != null) {
            this.setCProject(new CProject(project.getElementName()));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            this.setLanguage(element.getLanguage());
        }
        catch (CoreException e) {
            throw new IllegalArgumentException(e);
        }
        this.setLocationURI(element.getLocationURI());
        if (element instanceof IHasManagedLocation) {
            IHasManagedLocation hml = (IHasManagedLocation)element;
            this.setManagedLocation(hml.getManagedLocation());
        } else {
            URI managedURI = EFSExtensionManager.getDefault().getLinkedURI(element.getLocationURI());
            this.setManagedLocation(managedURI);
        }
        if (element instanceof IHasRemotePath) {
            IHasRemotePath hasRemotePath = (IHasRemotePath)element;
            this.setRemotePath(hasRemotePath.getRemotePath());
        } else {
            String remotePath = EFSExtensionManager.getDefault().getPathFromURI(element.getLocationURI());
            this.setRemotePath(remotePath);
        }
        this.isHeaderUnit = element.isHeaderUnit();
    }

    public void setASTContext(IScannerInfo scannerInfo, Map<String, String> languageProperties) {
        this.fScannerInfo = scannerInfo;
        this.fLanguageProperties = languageProperties;
    }

    public String getLanguageId() {
        return this.fLanguageId;
    }

    public Map<String, String> getLanguageProperties() {
        return this.fLanguageProperties;
    }

    public IInclude createInclude(String name, boolean isStd, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public INamespace createNamespace(String namespace, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String name, boolean isDirective, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory bufferFactory) {
        return null;
    }

    public IASTTranslationUnit getAST() throws CoreException {
        return this.getAST(null, 0);
    }

    public void setLanguage(ILanguage language) {
        this.fLanguage = language;
        this.fLanguageId = language == null ? null : language.getId();
    }

    private IncludeFileContentProvider getIncludeFileContentProvider(int style, IIndex index, int linkageID) {
        RemoteIndexerInputAdapter pathResolver = new RemoteIndexerInputAdapter();
        IncludeFileContentProvider fileContentsProvider = (style & 4) != 0 ? IncludeFileContentProvider.getEmptyFilesProvider() : IncludeFileContentProvider.getSavedFilesProvider();
        if (index != null && (style & 2) != 0) {
            IndexBasedFileContentProvider ibcf = new IndexBasedFileContentProvider(index, (ASTFilePathResolver)pathResolver, linkageID, fileContentsProvider);
            if ((style & 0x20) != 0) {
                ibcf.setSupportFillGapFromContextToHeader(true);
            }
            fileContentsProvider = ibcf;
        }
        return fileContentsProvider;
    }

    public IASTTranslationUnit getAST(IIndex index, int style) throws CoreException {
        ILanguage language;
        this.checkState();
        IScannerInfo scanInfo = this.getScannerInfo(true);
        if (scanInfo == null) {
            return null;
        }
        FileContent fileContent = FileContent.create((String)this.getPathForASTFileLocation(), (char[])this.getContents());
        if (fileContent != null && (language = this.getLanguage()) != null) {
            IncludeFileContentProvider crf = this.getIncludeFileContentProvider(style, index, language.getLinkageID());
            int options = 0;
            if ((style & 1) != 0) {
                options |= 1;
            }
            if ((style & 0x40) != 0) {
                options |= 0x10;
            }
            if ((style & 0x80) != 0) {
                options |= 0x20;
            }
            if (this.isSourceUnit()) {
                options |= 8;
            }
            DefaultLogService log = new DefaultLogService();
            return ((AbstractLanguage)language).getASTTranslationUnit(fileContent, scanInfo, crf, index, options, (IParserLogService)log);
        }
        return null;
    }

    public int getParserOptions(String filePath) {
        if (filePath.endsWith(".cpp") || filePath.endsWith(".C") || filePath.endsWith(".c")) {
            return 8;
        }
        return 0;
    }

    public CodeReader getCodeReader() {
        URI uri = null;
        uri = this.fManagedLocation != null ? this.fManagedLocation : this.fLocation;
        if (uri == null) {
            return null;
        }
        String filePath = this.fRemotePath != null ? this.fRemotePath : uri.getPath();
        try {
            return new CodeReader(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IASTCompletionNode getCompletionNode(IIndex index, int style, int offset) throws CoreException {
        this.checkState();
        IScannerInfo scanInfo = this.getScannerInfo(true);
        if (scanInfo == null) {
            return null;
        }
        FileContent fileContent = FileContent.create((String)this.getPathForASTFileLocation(), (char[])this.getContents());
        ILanguage language = this.getLanguage();
        if (language != null) {
            IASTTranslationUnit ast;
            IncludeFileContentProvider crf = this.getIncludeFileContentProvider(style, index, language.getLinkageID());
            IASTCompletionNode result = language.getCompletionNode(fileContent, scanInfo, crf, index, (IParserLogService)new DefaultLogService(), offset);
            if (result != null && (ast = result.getTranslationUnit()) != null) {
                ast.setIsHeaderUnit(false);
            }
            return result;
        }
        return null;
    }

    public String getContentTypeId() {
        return null;
    }

    public char[] getContents() {
        return new char[0];
    }

    public ICElement getElement(String name) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        return null;
    }

    public ICElement getElementAtOffset(int offset) throws CModelException {
        return null;
    }

    public ICElement[] getElementsAtOffset(int offset) throws CModelException {
        return null;
    }

    public IInclude getInclude(String name) {
        try {
            ICElement[] celements;
            ICElement[] iCElementArray = celements = this.getChildren();
            int n = celements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement celement = iCElementArray[n2];
                if (celement.getElementType() == 75 && name.equals(celement.getElementName())) {
                    return (IInclude)celement;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        ICElement[] iCElementArray = celements;
        int n = celements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement celement = iCElementArray[n2];
            if (celement.getElementType() == 75) {
                aList.add(celement);
            }
            ++n2;
        }
        return aList.toArray(new IInclude[0]);
    }

    public ILanguage getLanguage() throws CoreException {
        this.checkState();
        return this.fLanguage;
    }

    private void checkState() {
        if (this.fLanguage == null && this.fLanguageId != null) {
            if (RemoteUtil.isRemote()) {
                DataStore dataStore = null;
                if (Thread.currentThread() instanceof CDTMiner) {
                    dataStore = ((CDTMiner)((Object)Thread.currentThread()))._dataStore;
                }
                this.fLanguage = RemoteLanguageMapper.getLanguageById(this.fLanguageId, this.fLanguageProperties, dataStore);
                if (this.fLanguageProperties != null && this.fLanguage instanceof IConfigurableLanguage) {
                    ((IConfigurableLanguage)this.fLanguage).setProperties(this.fLanguageProperties);
                }
            } else {
                this.fLanguage = LanguageManager.getInstance().getLanguage(this.fLanguageId);
            }
        }
    }

    public IPath getLocation() {
        URI uri = null;
        uri = this.fManagedLocation != null ? this.fManagedLocation : this.fLocation;
        if (uri == null) {
            return null;
        }
        String filePath = this.fRemotePath != null ? this.fRemotePath : uri.getPath();
        return new Path(filePath);
    }

    public INamespace getNamespace(String name) {
        return null;
    }

    public INamespace[] getNamespaces() throws CModelException {
        return null;
    }

    public IScannerInfo getScannerInfo(boolean force) {
        return this.fScannerInfo;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return null;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        return null;
    }

    public IUsing getUsing(String name) {
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return null;
    }

    public boolean isASMLanguage() {
        return false;
    }

    public boolean isCLanguage() {
        return false;
    }

    public boolean isCXXLanguage() {
        return false;
    }

    public boolean isHeaderUnit() {
        return this.isHeaderUnit;
    }

    public boolean isSourceUnit() {
        return !this.isHeaderUnit;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public Map parse() {
        return null;
    }

    public void setIsStructureKnown(boolean wasSuccessful) {
    }

    public void close() throws CModelException {
    }

    public IBuffer getBuffer() throws CModelException {
        return null;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public void makeConsistent(IProgressMonitor progress) throws CModelException {
    }

    public void makeConsistent(IProgressMonitor progress, boolean forced) throws CModelException {
    }

    public void open(IProgressMonitor progress) throws CModelException {
    }

    public void save(IProgressMonitor progress, boolean force) throws CModelException {
    }

    public void bufferChanged(BufferChangedEvent event) {
    }

    public String getSource() throws CModelException {
        return null;
    }

    public ISourceRange getSourceRange() throws CModelException {
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public IProblemRequestor getProblemRequestor() {
        return null;
    }

    public IWorkingCopy findSharedWorkingCopy() {
        return null;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IProblemRequestor requestor) throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor) throws CModelException {
        return null;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    private String getPathForASTFileLocation() {
        String pathString = this.getRemotePath();
        if (pathString == null) {
            pathString = this.getLocation().toOSString();
        }
        return pathString;
    }
}

