/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.index.DummyName;
import org.eclipse.ptp.internal.rdt.core.search.RemoteASTTypeInfo;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteSearchQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURANCES = 7;
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;
    protected List<RemoteSearchMatch> fMatches;
    protected IIndexLocationConverter fConverter;

    protected RemoteSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.scope = scope;
        if (scope != null) {
            HashMap<String, ICProject> projectMap = new HashMap<String, ICProject>();
            int i = 0;
            while (i < scope.length) {
                ICProject project = scope[i].getCProject();
                if (project != null) {
                    projectMap.put(project.getElementName(), project);
                }
                ++i;
            }
            this.projects = projectMap.values().toArray(new ICProject[projectMap.size()]);
        }
        this.fMatches = new LinkedList<RemoteSearchMatch>();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected boolean filterName(IIndexName name) {
        return false;
    }

    private void collectNames(IIndex index, IIndexName[] names) throws CoreException {
        int i = 0;
        while (i < names.length) {
            IIndexName name = names[i];
            if (!this.filterName(name)) {
                IASTFileLocation loc = name.getFileLocation();
                IIndexBinding binding = index.findBinding((IName)name);
                IIndexFileLocation indexLocation = this.fConverter.fromInternalFormat(loc.getFileName());
                this.fMatches.add(new RemoteSearchMatch(index, binding, new DummyName(name, loc, indexLocation), loc.getNodeOffset(), loc.getNodeLength()));
            }
            ++i;
        }
    }

    protected void createMatches(IIndex index, IBinding binding) throws CoreException {
        if (binding != null) {
            IIndexName[] names = index.findNames(binding, this.flags);
            this.collectNames(index, names);
        }
    }

    protected void createLocalMatches(IASTTranslationUnit ast, IBinding binding) {
        if (binding != null) {
            HashSet<IASTName> names = new HashSet<IASTName>();
            names.addAll(Arrays.asList(ast.getDeclarationsInAST(binding)));
            names.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
            names.addAll(Arrays.asList(ast.getReferences(binding)));
            for (IASTName name : names) {
                ITypeReference ref;
                RemoteASTTypeInfo typeInfo;
                if (!((this.flags & 1) != 0 && name.isDeclaration() || (this.flags & 2) != 0 && name.isDefinition()) && ((this.flags & 4) == 0 || !name.isReference()) || (typeInfo = RemoteASTTypeInfo.create(name)) == null || (ref = typeInfo.getResolvedReference()) == null) continue;
                IASTFileLocation loc = name.getFileLocation();
                IIndexFileLocation indexLocation = this.fConverter.fromInternalFormat(typeInfo.getIFL().getFullPath());
                DummyName indexName = new DummyName(name, loc, indexLocation);
                this.fMatches.add(new RemoteSearchMatch(indexName, typeInfo, ref.getOffset(), ref.getLength()));
            }
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public abstract void runWithIndex(IIndex var1, IIndex var2, IIndexLocationConverter var3, IProgressMonitor var4) throws OperationCanceledException, CoreException, DOMException, InterruptedException;

    public IStatus runWithIndex(IWritableIndex[] indexList, IIndexLocationConverter converter, IProgressMonitor monitor) {
        int n;
        IStatus status = null;
        IWritableIndex searchScopeIndex = null;
        if (indexList.length == 1) {
            searchScopeIndex = indexList[0];
        } else if (indexList.length > 1) {
            HashSet<IWritableIndexFragment> fragments = new HashSet<IWritableIndexFragment>();
            IWritableIndex[] iWritableIndexArray = indexList;
            int n2 = indexList.length;
            n = 0;
            while (n < n2) {
                IWritableIndex projectIndex = iWritableIndexArray[n];
                if (projectIndex != null) {
                    IWritableIndexFragment fragment = projectIndex.getWritableFragment();
                    fragments.add(fragment);
                }
                ++n;
            }
            if (!fragments.isEmpty()) {
                searchScopeIndex = new CIndex(fragments.toArray(new IIndexFragment[fragments.size()]), fragments.size());
            }
        }
        if (searchScopeIndex != null) {
            IWritableIndex[] iWritableIndexArray = indexList;
            n = indexList.length;
            int n3 = 0;
            while (n3 < n) {
                IWritableIndex projectIndex = iWritableIndexArray[n3];
                try {
                    if (projectIndex != null) {
                        this.runWithIndex((IIndex)projectIndex, (IIndex)searchScopeIndex, converter, monitor);
                    }
                }
                catch (InterruptedException e1) {
                    status = status != null ? CCorePlugin.createStatus((String)(String.valueOf(status.getMessage()) + "::" + e1.getMessage())) : CCorePlugin.createStatus((String)e1.getMessage());
                }
                catch (CoreException e2) {
                    status = status != null ? CCorePlugin.createStatus((String)(String.valueOf(status.getMessage()) + "::" + e2.getMessage())) : CCorePlugin.createStatus((String)e2.getMessage());
                }
                catch (DOMException e3) {
                    status = status != null ? CCorePlugin.createStatus((String)(String.valueOf(status.getMessage()) + "::" + e3.getMessage())) : CCorePlugin.createStatus((String)e3.getMessage());
                }
                ++n3;
            }
        }
        if (status != null) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public List<RemoteSearchMatch> getMatches() {
        return this.fMatches;
    }

    public void setMatches(List<RemoteSearchMatch> matches) {
        this.fMatches = matches;
    }

    public ICProject[] getProjects() {
        return this.projects;
    }

    public String getScopeDescription() {
        StringBuilder buf = new StringBuilder();
        if (this.scope == null) {
            return "";
        }
        switch (this.scope.length) {
            case 0: {
                break;
            }
            case 1: {
                buf.append(this.scope[0].getElementName());
                break;
            }
            case 2: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                break;
            }
            default: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                buf.append(", ...");
            }
        }
        return buf.toString();
    }
}

