/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.rse.core.IRSESystemType;

public class RSEFileManager
implements IRemoteFileManager {
    private final RSEConnection fConnection;

    public RSEFileManager(RSEConnection conn) {
        this.fConnection = conn;
    }

    public String getDirectorySeparator() {
        IRSESystemType systemType = this.fConnection.getHost().getSystemType();
        if (systemType.isWindows()) {
            return "\\";
        }
        return "/";
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = new Path(this.fConnection.getWorkingDirectory()).append((IPath)path);
        }
        try {
            return EFS.getFileSystem((String)"rse").getStore(this.toURI((IPath)path));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        try {
            return new URI("rse", this.fConnection.getHost().getHostName(), path.toString(), this.fConnection.getHost().getAliasName(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

