/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.runtime.server;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.command.IProxyCommandListener;
import org.eclipse.ptp.proxy.command.IProxyQuitCommand;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeInitCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeModelDefCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeStartEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeSubmitJobCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeTerminateJobCommand;
import org.eclipse.ptp.proxy.runtime.command.ProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.proxy.runtime.server.ElementIDGenerator;
import org.eclipse.ptp.proxy.server.AbstractProxyServer;

public abstract class AbstractProxyRuntimeServer
extends AbstractProxyServer
implements IProxyCommandListener {
    private final LinkedBlockingQueue<IProxyCommand> fCommands = new LinkedBlockingQueue();
    protected final IProxyRuntimeEventFactory fEventFactory;
    public int fEventLoopTransID;
    protected Thread fEventThread;
    protected Thread eventThread;

    public AbstractProxyRuntimeServer(String host, int port, IProxyRuntimeEventFactory eventFactory) {
        super(host, port, new ProxyRuntimeCommandFactory());
        this.fEventFactory = eventFactory;
        this.addListener(this);
    }

    protected IProxyRuntimeEventFactory getEventFactory() {
        return this.fEventFactory;
    }

    protected Thread getEventThread() {
        return this.fEventThread;
    }

    public void handleCommand(IProxyCommand c) {
        this.fCommands.add(c);
    }

    protected abstract void initServer() throws Exception;

    protected void runStateMachine() throws InterruptedException, IOException {
        block7: while (this.state != AbstractProxyServer.ServerState.SHUTDOWN) {
            System.out.println("runStateMachine: state: " + (Object)((Object)this.state));
            switch (this.state) {
                case INIT: {
                    IProxyEvent event;
                    IProxyCommand command = this.fCommands.take();
                    int base_ID = Integer.parseInt(command.getArguments()[1].split("=")[1]);
                    new ElementIDGenerator(base_ID);
                    int transID = command.getTransactionID();
                    System.out.println("runStateMachine: command: " + command.getCommandID() + " (" + transID + ")");
                    if (command instanceof IProxyRuntimeInitCommand) {
                        try {
                            this.initServer();
                            event = this.fEventFactory.newOKEvent(transID);
                            this.sendEvent(event);
                            this.state = AbstractProxyServer.ServerState.DISCOVERY;
                        }
                        catch (Exception e) {
                            event = this.fEventFactory.newErrorEvent(transID, 0, e.getMessage());
                            e.printStackTrace();
                            this.sendEvent(event);
                            this.state = AbstractProxyServer.ServerState.SHUTDOWN;
                        }
                        continue block7;
                    }
                    System.err.println("unexpected command (INIT): " + command);
                    break;
                }
                case DISCOVERY: {
                    IProxyEvent event;
                    IProxyCommand command = this.fCommands.take();
                    int transID = command.getTransactionID();
                    System.out.println("runStateMachine: command: " + command.getCommandID() + " (" + transID + ")");
                    if (command instanceof IProxyRuntimeModelDefCommand) {
                        event = this.fEventFactory.newOKEvent(transID);
                        this.sendEvent(event);
                        this.state = AbstractProxyServer.ServerState.NORMAL;
                        break;
                    }
                    System.err.println("unexpected command (DISC): " + command);
                    break;
                }
                case NORMAL: {
                    IProxyEvent event;
                    IProxyCommand command = this.fCommands.take();
                    int transID = command.getTransactionID();
                    System.out.println("runStateMachine: command: " + command.getCommandID() + " (" + transID + ")");
                    if (command instanceof IProxyRuntimeStartEventsCommand) {
                        if (this.fEventThread != null) break;
                        this.fEventLoopTransID = transID;
                        this.startEventThread(transID);
                        break;
                    }
                    if (command instanceof IProxyQuitCommand) {
                        event = this.fEventFactory.newShutdownEvent(transID);
                        this.sendEvent(event);
                        this.state = AbstractProxyServer.ServerState.SHUTDOWN;
                        break;
                    }
                    if (command instanceof IProxyRuntimeTerminateJobCommand) {
                        this.terminateJob(transID, command.getArguments());
                        break;
                    }
                    if (command instanceof IProxyRuntimeSubmitJobCommand) {
                        this.submitJob(transID, command.getArguments());
                        break;
                    }
                    System.err.println("unexpected command (NORM): " + command);
                }
            }
        }
    }

    public void sendEvent(IProxyEvent event) throws IOException {
        ProxyPacket packet = new ProxyPacket(event);
        packet.send(this.sessOutput);
    }

    protected void setEventThread(Thread thread) {
        this.fEventThread = thread;
    }

    protected abstract void startEventThread(int var1);

    protected abstract void submitJob(int var1, String[] var2);

    protected abstract void terminateJob(int var1, String[] var2);
}

