/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.photran.internal.ui.views.vpgproblems.Messages;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ErrorWarningFilterAction
extends Action {
    private StructuredViewer viewer;

    public ErrorWarningFilterAction(StructuredViewer viewer, int severity) {
        super(ErrorWarningFilterAction.getLabel(severity), 2);
        this.viewer = viewer;
        this.setChecked(true);
        viewer.addFilter((ViewerFilter)new MarkerSeverityFilter(severity));
    }

    private static String getLabel(int severity) {
        switch (severity) {
            case 2: {
                return Messages.ErrorWarningFilterAction_Errors;
            }
            case 1: {
                return Messages.ErrorWarningFilterAction_Warnings;
            }
        }
        throw new IllegalStateException();
    }

    public void run() {
        this.viewer.refresh();
    }

    private class MarkerSeverityFilter
    extends ViewerFilter {
        private int severityToPermit;

        private MarkerSeverityFilter(int severity) {
            this.severityToPermit = severity;
        }

        public boolean select(Viewer viewer, Object parentElem, Object elem) {
            IMarker marker = (IMarker)elem;
            if (MarkerUtilities.getSeverity((IMarker)marker) == this.severityToPermit) {
                return ErrorWarningFilterAction.this.isChecked();
            }
            return true;
        }
    }
}

