/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.io.InputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;

public class ProcessInputStream
extends InputStream
implements IJobChildListener {
    protected List<String> buffers;
    protected int pos;
    protected int count;
    private String currentBuffer;
    private final IPJob job;
    private final int processJobRank;

    public ProcessInputStream(IPJob job, int processJobRank) {
        this.job = job;
        this.processJobRank = processJobRank;
        this.buffers = Collections.synchronizedList(new LinkedList());
        job.addChildListener((IJobChildListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInput(String buffer) {
        List<String> list = this.buffers;
        synchronized (list) {
            this.buffers.add(buffer == null ? "" : buffer);
            this.buffers.notifyAll();
        }
    }

    public void close() {
        this.addInput("");
        this.job.removeChildListener((IJobChildListener)this);
    }

    public void handleEvent(IChangedProcessEvent e) {
        StringAttribute stdoutAttr;
        BitSet processChangedSet = e.getProcesses();
        if (!processChangedSet.get(this.processJobRank)) {
            return;
        }
        if (this.job.getProcessState(this.processJobRank) == ProcessAttributes.State.COMPLETED) {
            this.close();
        }
        if ((stdoutAttr = (StringAttribute)e.getAttributes().getAttribute((IAttributeDefinition)ProcessAttributes.getStdoutAttributeDefinition())) != null) {
            this.addInput(String.valueOf(stdoutAttr.getValue()) + "\n");
        }
    }

    public void handleEvent(INewProcessEvent e) {
    }

    public void handleEvent(IRemoveProcessEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        List<String> list = this.buffers;
        synchronized (list) {
            if (this.count <= this.pos) {
                this.currentBuffer = this.getBuffer();
            }
            return this.pos < this.count ? this.currentBuffer.charAt(this.pos++) & 0xFF : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) {
        List<String> list = this.buffers;
        synchronized (list) {
            String buffer;
            block10: {
                block9: {
                    buffer = this.getBuffer();
                    if (b == null) {
                        throw new NullPointerException();
                    }
                    if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (this.pos < this.count) break block9;
                    return -1;
                }
                if (this.pos + len > this.count) {
                    len = this.count - this.pos;
                }
                if (len > 0) break block10;
                return 0;
            }
            int cnt = len;
            while (--cnt >= 0) {
                b[off++] = (byte)buffer.charAt(this.pos++);
            }
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int len) {
        List<String> list = this.buffers;
        synchronized (list) {
            this.pos = 0;
            this.count = len;
        }
    }

    public void restart() {
        this.job.addChildListener((IJobChildListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBuffer() {
        List<String> list = this.buffers;
        synchronized (list) {
            while (true) {
                if (!this.buffers.isEmpty()) {
                    String buffer = this.buffers.remove(0);
                    this.reset(buffer.length());
                    return buffer;
                }
                try {
                    this.buffers.wait();
                }
                catch (InterruptedException interruptedException) {
                    String string = "";
                }
            }
        }
    }
}

