/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.contentassist;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.AccessContext;
import org.eclipse.ptp.internal.rdt.core.contentassist.CompletionType;
import org.eclipse.ptp.internal.rdt.core.contentassist.Proposal;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteProposalContextInformation;
import org.eclipse.ptp.internal.rdt.core.contentassist.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionProposalComputer {
    public List<Proposal> computeCompletionProposals(RemoteContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        LinkedList<Proposal> proposals = new LinkedList<Proposal>();
        if (context.isInPreprocessorDirective()) {
            if (!context.inPreprocessorKeyword()) {
                String computedPrefix;
                if (prefix.length() == 0 && (computedPrefix = context.computeIdentifierPrefix().toString()) != null) {
                    prefix = computedPrefix;
                }
                this.addMacroProposals(context, prefix, proposals);
            }
        } else {
            IASTName[] names;
            boolean handleMacros = false;
            IASTName[] iASTNameArray = names = completionNode.getNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTCompletionContext astContext;
                IASTName name = iASTNameArray[n2];
                if (name.getTranslationUnit() != null && (astContext = name.getCompletionContext()) != null) {
                    IBinding[] bindings;
                    if (astContext instanceof IASTIdExpression || astContext instanceof IASTNamedTypeSpecifier) {
                        handleMacros = prefix.length() > 0;
                    }
                    if ((bindings = astContext.findBindings(name, !context.isContextInformationStyle())) != null) {
                        AccessContext accessibilityContext = new AccessContext(name);
                        IBinding[] iBindingArray = bindings;
                        int n3 = bindings.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBinding binding = iBindingArray[n4];
                            if (accessibilityContext.isAccessible(binding)) {
                                this.handleBinding(binding, context, prefix, astContext, proposals);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (handleMacros) {
                this.addMacroProposals(context, prefix, proposals);
            }
        }
        return proposals;
    }

    private void addMacroProposals(RemoteContentAssistInvocationContext context, String prefix, List<Proposal> proposals) {
        char[] macroName;
        int i;
        char[] prefixChars = prefix.toCharArray();
        boolean matchPrefix = !context.isContextInformationStyle();
        IASTCompletionNode completionNode = context.getCompletionNode();
        IASTPreprocessorMacroDefinition[] macros = completionNode.getTranslationUnit().getMacroDefinitions();
        if (macros != null) {
            i = 0;
            while (i < macros.length) {
                macroName = macros[i].getName().toCharArray();
                if (CharArrayUtils.equals((char[])macroName, (int)0, (int)(matchPrefix ? prefixChars.length : macroName.length), (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(macros[i], context, prefix, proposals);
                }
                ++i;
            }
        }
        if ((macros = completionNode.getTranslationUnit().getBuiltinMacroDefinitions()) != null) {
            i = 0;
            while (i < macros.length) {
                macroName = macros[i].getName().toCharArray();
                if (CharArrayUtils.equals((char[])macroName, (int)0, (int)(matchPrefix ? prefixChars.length : macroName.length), (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(macros[i], context, prefix, proposals);
                }
                ++i;
            }
        }
    }

    private void handleMacro(IASTPreprocessorMacroDefinition macro, RemoteContentAssistInvocationContext context, String prefix, List<Proposal> proposals) {
        String macroName = macro.getName().toString();
        int baseRelevance = this.computeBaseRelevance(prefix, macroName);
        CompletionType type = new CompletionType(79);
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition functionMacro = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            StringBuilder repStringBuff = new StringBuilder();
            repStringBuff.append(macroName);
            repStringBuff.append('(');
            StringBuilder args = new StringBuilder();
            IASTFunctionStyleMacroParameter[] params = functionMacro.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        args.append(", ");
                    }
                    args.append(params[i].getParameter());
                    ++i;
                }
            }
            String argString = args.toString();
            StringBuilder descStringBuff = new StringBuilder(repStringBuff.toString());
            descStringBuff.append(argString);
            descStringBuff.append(')');
            repStringBuff.append(')');
            String repString = repStringBuff.toString();
            String descString = descStringBuff.toString();
            Proposal proposal = this.createProposal(repString, descString, prefix.length(), type, baseRelevance + 15, context);
            if (!context.isContextInformationStyle()) {
                if (argString.length() > 0) {
                    proposal.setCursorPosition(repString.length() - 1);
                } else {
                    proposal.setCursorPosition(repString.length());
                }
            }
            if (argString.length() > 0) {
                RemoteProposalContextInformation info = new RemoteProposalContextInformation(type, descString, argString);
                info.setContextInformationPosition(context.getContextInformationOffset());
                proposal.setContextInformation(info);
            }
            proposals.add(proposal);
        } else {
            proposals.add(this.createProposal(macroName, macroName, prefix.length(), type, baseRelevance + 15, context));
        }
    }

    protected void handleBinding(IBinding binding, RemoteContentAssistInvocationContext cContext, String prefix, IASTCompletionContext astContext, List<Proposal> proposals) {
        if ((binding instanceof CPPImplicitFunction || binding instanceof CPPImplicitTypedef || binding instanceof CPPBuiltinVariable || binding instanceof CPPBuiltinParameter || binding instanceof CImplicitFunction || binding instanceof CImplicitTypedef || binding instanceof CBuiltinVariable || binding instanceof CBuiltinParameter) && !(binding instanceof CPPImplicitMethod)) {
            return;
        }
        if (!this.isAnonymousBinding(binding)) {
            String name = binding.getName();
            int baseRelevance = this.computeBaseRelevance(prefix, name);
            if (binding instanceof ICPPClassType) {
                this.handleClass((ICPPClassType)binding, astContext, cContext, baseRelevance, proposals);
            } else if (binding instanceof IFunction) {
                this.handleFunction((IFunction)binding, cContext, baseRelevance, proposals);
            } else if (!cContext.isContextInformationStyle()) {
                if (binding instanceof IVariable) {
                    this.handleVariable((IVariable)binding, cContext, baseRelevance, proposals);
                } else if (binding instanceof ITypedef) {
                    proposals.add(this.createProposal(name, name, this.getElementType(binding), baseRelevance + 60, cContext));
                } else if (binding instanceof ICPPNamespace) {
                    this.handleNamespace((ICPPNamespace)binding, astContext, cContext, baseRelevance, proposals);
                } else if (binding instanceof IEnumeration) {
                    proposals.add(this.createProposal(name, name, this.getElementType(binding), baseRelevance + 30, cContext));
                } else if (binding instanceof IEnumerator) {
                    proposals.add(this.createProposal(name, name, this.getElementType(binding), baseRelevance + 40, cContext));
                } else {
                    proposals.add(this.createProposal(name, name, this.getElementType(binding), baseRelevance + 20, cContext));
                }
            }
        }
    }

    private boolean isAnonymousBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        return name.length == 0 || name[0] == '{';
    }

    private void handleClass(ICPPClassType classType, IASTCompletionContext astContext, RemoteContentAssistInvocationContext context, int baseRelevance, List<Proposal> proposals) {
        if (context.isContextInformationStyle()) {
            try {
                ICPPConstructor[] constructors;
                ICPPConstructor[] iCPPConstructorArray = constructors = classType.getConstructors();
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor constructor = iCPPConstructorArray[n2];
                    this.handleFunction((IFunction)constructor, context, baseRelevance, proposals);
                    ++n2;
                }
            }
            catch (DOMException dOMException) {}
        } else {
            IASTName name;
            int relevance = 0;
            try {
                switch (classType.getKey()) {
                    case 3: {
                        relevance = 90;
                        break;
                    }
                    case 1: {
                        relevance = 80;
                        break;
                    }
                    case 2: {
                        relevance = 70;
                    }
                }
            }
            catch (DOMException dOMException) {}
            if (astContext instanceof IASTName && !(astContext instanceof ICPPASTQualifiedName) && (name = (IASTName)astContext).getParent() instanceof IASTDeclarator) {
                proposals.add(this.createProposal(String.valueOf(classType.getName()) + "::", classType.getName(), this.getElementType((IBinding)classType), baseRelevance + relevance, context));
            }
            proposals.add(this.createProposal(classType.getName(), classType.getName(), this.getElementType((IBinding)classType), baseRelevance + 90, context));
        }
    }

    private void handleFunction(IFunction function, RemoteContentAssistInvocationContext context, int baseRelevance, List<Proposal> proposals) {
        CompletionType type = this.getElementType((IBinding)function);
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(function.getName());
        repStringBuff.append('(');
        StringBuilder dispargs = new StringBuilder();
        StringBuilder idargs = new StringBuilder();
        boolean hasArgs = true;
        String returnTypeStr = null;
        try {
            IType returnType;
            IFunctionType functionType;
            IParameter[] params = function.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    IType paramType = params[i].getType();
                    if (i > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    idargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    String paramName = params[i].getName();
                    if (paramName != null && paramName.length() > 0) {
                        dispargs.append(' ');
                        dispargs.append(paramName);
                    }
                    ++i;
                }
                if (function.takesVarArgs()) {
                    if (params.length > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append("...");
                    idargs.append("...");
                } else if (params.length == 0) {
                    dispargs.append("void");
                    idargs.append("void");
                }
            }
            if ((functionType = function.getType()) != null && (returnType = functionType.getReturnType()) != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)returnType, (boolean)false);
            }
            hasArgs = ASTTypeUtil.functionTakesParameters((IFunction)function);
        }
        catch (DOMException dOMException) {}
        String dispargString = dispargs.toString();
        String idargString = idargs.toString();
        String contextDispargString = hasArgs ? dispargString : null;
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        dispStringBuff.append(dispargString);
        dispStringBuff.append(')');
        if (returnTypeStr != null && returnTypeStr.length() > 0) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        idStringBuff.append(idargString);
        idStringBuff.append(')');
        String idString = idStringBuff.toString();
        repStringBuff.append(')');
        String repString = repStringBuff.toString();
        int relevance = function instanceof ICPPMethod ? 120 : 100;
        Proposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), type, baseRelevance + relevance, context);
        if (!context.isContextInformationStyle()) {
            int cursorPosition = hasArgs ? repString.length() - 1 : repString.length();
            proposal.setCursorPosition(cursorPosition);
        }
        if (contextDispargString != null) {
            RemoteProposalContextInformation info = new RemoteProposalContextInformation(type, dispString, contextDispargString);
            info.setContextInformationPosition(context.getContextInformationOffset());
            proposal.setContextInformation(info);
        }
        proposals.add(proposal);
    }

    private void handleVariable(IVariable variable, RemoteContentAssistInvocationContext context, int baseRelevance, List<Proposal> proposals) {
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(variable.getName());
        String returnTypeStr = "<unknown>";
        try {
            IType varType = variable.getType();
            if (varType != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)varType, (boolean)false);
            }
        }
        catch (DOMException dOMException) {}
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        if (returnTypeStr != null) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        String idString = idStringBuff.toString();
        String repString = repStringBuff.toString();
        CompletionType type = this.getElementType((IBinding)variable);
        int relevance = CompletionProposalComputer.isLocalVariable(variable) ? 140 : (CompletionProposalComputer.isField(variable) ? 130 : 110);
        Proposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), type, baseRelevance + relevance, context);
        proposals.add(proposal);
    }

    private static boolean isField(IVariable variable) {
        return variable instanceof IField;
    }

    private static boolean isLocalVariable(IVariable variable) {
        try {
            return CompletionProposalComputer.isLocalScope(variable.getScope());
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean isLocalScope(IScope scope) {
        while (scope != null) {
            if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                return true;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException dOMException) {
                scope = null;
            }
        }
        return false;
    }

    private void handleNamespace(ICPPNamespace namespace, IASTCompletionContext astContext, RemoteContentAssistInvocationContext cContext, int baseRelevance, List<Proposal> proposals) {
        if (astContext instanceof ICPPASTQualifiedName) {
            IASTCompletionContext parent = ((ICPPASTQualifiedName)astContext).getCompletionContext();
            this.handleNamespace(namespace, parent, cContext, baseRelevance, proposals);
            return;
        }
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(namespace.getName());
        if (!(astContext instanceof ICPPASTUsingDeclaration) && !(astContext instanceof ICPPASTUsingDirective)) {
            repStringBuff.append("::");
        }
        String repString = repStringBuff.toString();
        proposals.add(this.createProposal(repString, namespace.getName(), this.getElementType((IBinding)namespace), baseRelevance + 50, cContext));
    }

    private Proposal createProposal(String repString, String dispString, CompletionType type, int relevance, RemoteContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, context.getCompletionNode().getLength(), type, relevance, context);
    }

    private Proposal createProposal(String repString, String dispString, int prefixLength, CompletionType type, int relevance, RemoteContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, prefixLength, type, relevance, context);
    }

    private Proposal createProposal(String repString, String dispString, String idString, int prefixLength, CompletionType type, int relevance, RemoteContentAssistInvocationContext context) {
        int parseOffset = context.getParseOffset();
        int invocationOffset = context.getInvocationOffset();
        boolean doReplacement = !context.isContextInformationStyle();
        int repLength = doReplacement ? prefixLength : 0;
        int repOffset = doReplacement ? parseOffset - repLength : invocationOffset;
        repString = doReplacement ? repString : "";
        return new Proposal(repString, repOffset, repLength, type, dispString, idString, relevance);
    }

    private CompletionType getElementType(IBinding binding) {
        try {
            if (binding instanceof ITypedef) {
                return new CompletionType(80);
            }
            if (binding instanceof ICompositeType) {
                if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                    return new CompletionType(65);
                }
                if (((ICompositeType)binding).getKey() == 1) {
                    return new CompletionType(67);
                }
                if (((ICompositeType)binding).getKey() == 2) {
                    return new CompletionType(69);
                }
            } else {
                IBinding[] delegates;
                if (binding instanceof ICPPMethod) {
                    switch (((ICPPMethod)binding).getVisibility()) {
                        case 3: {
                            return new CompletionType(70, Visibility.Private);
                        }
                        case 2: {
                            return new CompletionType(70, Visibility.Protected);
                        }
                    }
                    return new CompletionType(70, Visibility.Public);
                }
                if (binding instanceof IFunction) {
                    return new CompletionType(74);
                }
                if (binding instanceof ICPPField) {
                    switch (((ICPPField)binding).getVisibility()) {
                        case 3: {
                            return new CompletionType(72, Visibility.Private);
                        }
                        case 2: {
                            return new CompletionType(72, Visibility.Protected);
                        }
                    }
                    return new CompletionType(72, Visibility.Public);
                }
                if (binding instanceof IField) {
                    return new CompletionType(72, Visibility.Public);
                }
                if (binding instanceof IVariable) {
                    return new CompletionType(76);
                }
                if (binding instanceof IEnumeration) {
                    return new CompletionType(63);
                }
                if (binding instanceof IEnumerator) {
                    return new CompletionType(81);
                }
                if (binding instanceof ICPPNamespace) {
                    return new CompletionType(61);
                }
                if (binding instanceof ICPPFunctionTemplate) {
                    return new CompletionType(74);
                }
                if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
                    return this.getElementType(delegates[0]);
                }
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    protected int computeBaseRelevance(String prefix, String match) {
        boolean exactNameMatch;
        boolean caseMatch;
        int baseRelevance = 20;
        boolean bl = caseMatch = prefix.length() > 0 && match.startsWith(prefix);
        if (caseMatch) {
            baseRelevance += 1000;
        }
        if (exactNameMatch = match.equalsIgnoreCase(prefix)) {
            baseRelevance += 40;
        }
        return baseRelevance;
    }
}

