/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTName
extends ASTNode
implements IASTName,
IASTCompletionContext {
    private final char[] name;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final String EMPTY_STRING = "";
    private IBinding binding = null;

    public CASTName(char[] name) {
        this.name = name;
    }

    public CASTName() {
        this.name = EMPTY_CHAR_ARRAY;
    }

    public CASTName copy() {
        CASTName copy = new CASTName(this.name == null ? null : (char[])this.name.clone());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IBinding resolveBinding() {
        if (this.binding == null) {
            CVisitor.createBinding(this);
        }
        return this.binding;
    }

    public IBinding resolvePreBinding() {
        return this.resolveBinding();
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public IBinding getPreBinding() {
        return this.binding;
    }

    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        if (this.getLength() > 0) {
            return this;
        }
        return null;
    }

    public void setBinding(IBinding binding) {
        this.binding = binding;
    }

    public String toString() {
        if (this.name == EMPTY_CHAR_ARRAY) {
            return EMPTY_STRING;
        }
        return new String(this.name);
    }

    public char[] toCharArray() {
        return this.name;
    }

    public char[] getSimpleID() {
        return this.name;
    }

    public char[] getLookupKey() {
        return this.name;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: 
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier specifier = (IASTElaboratedTypeSpecifier)parent;
            int kind = specifier.getKind();
            switch (kind) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    return null;
                }
            }
            IBinding[] bindings = CVisitor.findBindingsForContentAssist(n, isPrefix);
            return this.filterByElaboratedTypeSpecifier(kind, bindings);
        }
        return null;
    }

    private IBinding[] filterByElaboratedTypeSpecifier(int kind, IBinding[] bindings) {
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof ICompositeType) {
                ICompositeType type = (ICompositeType)bindings[i];
                try {
                    switch (type.getKey()) {
                        case 1: {
                            if (kind != 1) {
                                bindings[i] = null;
                            }
                            break;
                        }
                        case 2: {
                            if (kind == 2) break;
                            bindings[i] = null;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (DOMException e) {
                    bindings[i] = null;
                    CCorePlugin.log((Throwable)e);
                }
            } else {
                bindings[i] = null;
            }
            ++i;
        }
        return (IBinding[])ArrayUtil.removeNulls(IBinding.class, bindings);
    }

    public IASTName getLastName() {
        return this;
    }
}

