/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class ViewFilterAction
extends ViewerFilter
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart view = null;
    private IAction action = null;

    public void dispose() {
    }

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        this.view = view;
        this.action.setChecked(this.getPreferenceValue(view));
        this.run(this.action);
    }

    public void run(IAction action) {
        StructuredViewer viewer = this.getStructuredViewer();
        ViewerFilter[] filters = viewer.getFilters();
        ViewerFilter filter = null;
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == this) {
                filter = filters[i];
                break;
            }
            ++i;
        }
        if (filter == null) {
            viewer.addFilter((ViewerFilter)this);
        }
        viewer.refresh();
        Preferences store = this.getPreferences();
        String key = String.valueOf(this.getView().getSite().getId()) + "." + this.getPreferenceKey();
        store.setValue(key, action.isChecked());
        PTPDebugUIPlugin.getDefault().savePluginPreferences();
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract String getPreferenceKey();

    protected Preferences getPreferences() {
        return PTPDebugCorePlugin.getDefault().getPluginPreferences();
    }

    protected boolean getPreferenceValue(IViewPart part) {
        String baseKey = this.getPreferenceKey();
        String viewKey = part.getSite().getId();
        String compositeKey = String.valueOf(viewKey) + "." + baseKey;
        Preferences store = this.getPreferences();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(baseKey);
        return value;
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected boolean getValue() {
        return this.action.isChecked();
    }

    protected IViewPart getView() {
        return this.view;
    }
}

