/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.generic.core.rtsystem;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.generic.core.messages.Messages;
import org.eclipse.ptp.rm.generic.core.rmsystem.EffectiveGenericRMConfiguration;
import org.eclipse.ptp.rm.generic.core.rtsystem.GenericRMRuntimeSystemJob;

public class GenericRMRuntimeSystem
extends AbstractToolRuntimeSystem {
    private String fMachineID;
    private String fNodeID;
    private String fQueueID;

    public GenericRMRuntimeSystem(Integer openmpi_rmid, IToolRMConfiguration config, AttributeDefinitionManager attrDefMgr) {
        super(openmpi_rmid, config, attrDefMgr);
    }

    public Job createRuntimeSystemJob(String jobID, String queueID, AttributeManager attrMgr) {
        return new GenericRMRuntimeSystemJob(jobID, queueID, Messages.GenericRMRuntimeSystem_JobName, this, attrMgr);
    }

    public String getMachineID() {
        return this.fMachineID;
    }

    public String getNodeID() {
        return this.fNodeID;
    }

    public String getQueueID() {
        return this.fQueueID;
    }

    public AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveGenericRMConfiguration(this.getRmConfiguration());
    }

    protected Job createContinuousMonitorJob(IProgressMonitor monitor) {
        return null;
    }

    protected Job createDiscoverJob(IProgressMonitor monitor) {
        return null;
    }

    protected Job createPeriodicMonitorJob(IProgressMonitor monitor) {
        return null;
    }

    protected void doFilterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
    }

    protected void doShutdown() throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        this.setMachineID(this.createMachine(this.connection.getName()));
        this.setNodeID(this.createNode(this.getMachineID(), this.connection.getAddress(), 0));
        this.setQueueID(this.createQueue(Messages.GenericRMRuntimeSystem_0));
    }

    protected void doStopEvents() throws CoreException {
    }

    protected void setMachineID(String machineID) {
        this.fMachineID = machineID;
    }

    protected void setNodeID(String nodeID) {
        this.fNodeID = nodeID;
    }

    protected void setQueueID(String queueID) {
        this.fQueueID = queueID;
    }
}

