/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.resources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class FileStorage
extends PlatformObject
implements IStorage {
    IPath path;
    InputStream in = null;

    public FileStorage(IPath path) {
        this.path = path;
    }

    public FileStorage(InputStream in, IPath path) {
        this.path = path;
        this.in = in;
    }

    public InputStream getContents() throws CoreException {
        if (this.in == null) {
            try {
                return new FileInputStream(this.path.toFile());
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.core", 4, e.toString(), (Throwable)e));
            }
        }
        return this.in;
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return this.path.toOSString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IStorage) {
            IPath p = this.getFullPath();
            IPath objPath = ((IStorage)obj).getFullPath();
            if (p != null && objPath != null) {
                return p.equals((Object)objPath);
            }
        }
        return super.equals(obj);
    }
}

