/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAcImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTAllocateObjectNode;
import org.eclipse.photran.internal.core.parser.ASTArrayElementNode;
import org.eclipse.photran.internal.core.parser.ASTAssignStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignedGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCPrimaryNode;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCaseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockObjectNode;
import org.eclipse.photran.internal.core.parser.ASTCommonStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCycleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDataImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTDataRefNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtValueNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEditElementNode;
import org.eclipse.photran.internal.core.parser.ASTElseIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndBlockDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndForallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndInterfaceStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSelectStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFieldSelectorNode;
import org.eclipse.photran.internal.core.parser.ASTFinalBindingNode;
import org.eclipse.photran.internal.core.parser.ASTForallTripletSpecListNode;
import org.eclipse.photran.internal.core.parser.ASTFormatStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionArgListNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionParNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTGenericBindingNode;
import org.eclipse.photran.internal.core.parser.ASTInputImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTIoControlSpecNode;
import org.eclipse.photran.internal.core.parser.ASTLoopControlNode;
import org.eclipse.photran.internal.core.parser.ASTMaskedElseWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTModuleProcedureStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNamedConstantUseNode;
import org.eclipse.photran.internal.core.parser.ASTNamelistGroupsNode;
import org.eclipse.photran.internal.core.parser.ASTNamelistStmtNode;
import org.eclipse.photran.internal.core.parser.ASTOutputImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTPointerFieldNode;
import org.eclipse.photran.internal.core.parser.ASTPointerObjectNode;
import org.eclipse.photran.internal.core.parser.ASTProcedureNameListNode;
import org.eclipse.photran.internal.core.parser.ASTSFDataRefNode;
import org.eclipse.photran.internal.core.parser.ASTSFDummyArgNameListNode;
import org.eclipse.photran.internal.core.parser.ASTSFExprListNode;
import org.eclipse.photran.internal.core.parser.ASTSFVarNameNode;
import org.eclipse.photran.internal.core.parser.ASTScalarVariableNode;
import org.eclipse.photran.internal.core.parser.ASTSpecificBindingNode;
import org.eclipse.photran.internal.core.parser.ASTStmtFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTStructureComponentNode;
import org.eclipse.photran.internal.core.parser.ASTStructureConstructorNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineArgNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.ASTUFPrimaryNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.ASTVariableNode;
import org.eclipse.photran.internal.core.parser.ASTWaitSpecNode;
import org.eclipse.photran.internal.core.parser.ASTWaitStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceCollector
extends BindingCollector {
    ReferenceCollector() {
    }

    @Override
    public void visitASTFormatStmtNode(ASTFormatStmtNode node) {
    }

    @Override
    public void visitASTSFDataRefNode(ASTSFDataRefNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTCPrimaryNode(ASTCPrimaryNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName().getName());
        }
    }

    @Override
    public void visitASTUFPrimaryNode(ASTUFPrimaryNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName().getName());
        }
    }

    @Override
    public void visitASTNamedConstantUseNode(ASTNamedConstantUseNode node) {
        super.traverseChildren(node);
        this.bind(node.getName());
    }

    @Override
    public void visitASTEndTypeStmtNode(ASTEndTypeStmtNode node) {
        super.traverseChildren(node);
        if (node.getTypeName() != null) {
            this.bind(node.getTypeName().getTypeName());
        }
    }

    @Override
    public void visitASTStructureConstructorNode(ASTStructureConstructorNode node) {
        super.traverseChildren(node);
        this.bind(node.getTypeName());
    }

    @Override
    public void visitASTAcImpliedDoNode(ASTAcImpliedDoNode node) {
        super.traverseChildren(node);
        this.bind(node.getImpliedDoVariable().getImpliedDoVariable());
    }

    @Override
    public void visitASTTypeSpecNode(ASTTypeSpecNode node) {
        super.traverseChildren(node);
        if (node.getTypeName() != null) {
            this.bind(node.getTypeName());
        }
    }

    @Override
    public void visitASTDataImpliedDoNode(ASTDataImpliedDoNode node) {
        super.traverseChildren(node);
        this.bind(node.getImpliedDoVariable());
    }

    @Override
    public void visitASTDataStmtValueNode(ASTDataStmtValueNode node) {
        super.traverseChildren(node);
        if (node.getNamedConstKind() != null) {
            this.bind(node.getNamedConstKind().getName());
        }
    }

    @Override
    public void visitASTNamelistStmtNode(ASTNamelistStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTNamelistGroupsNode> groups = node.getNamelistGroups();
        int i = 0;
        while (i < groups.size()) {
            this.bind(((ASTNamelistGroupsNode)groups.get(i)).getVariableName());
            ++i;
        }
    }

    @Override
    public void visitASTCommonStmtNode(ASTCommonStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTCommonBlockNode> list = node.getCommonBlockList();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            IASTListNode<ASTCommonBlockObjectNode> objects = ((ASTCommonBlockNode)list.get(i)).getCommonBlockObjectList();
            int j = 0;
            while (j < objects.size()) {
                ASTCommonBlockObjectNode obj = (ASTCommonBlockObjectNode)objects.get(j);
                List<PhotranTokenRef> bindings = this.bind(obj.getVariableName());
                if (obj.getArraySpec() != null) {
                    try {
                        for (PhotranTokenRef tr : bindings) {
                            Definition def = this.vpg.getDefinitionFor(tr);
                            def.setArraySpec(obj.getArraySpec());
                            this.vpg.setDefinitionFor(tr, def);
                        }
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void visitASTScalarVariableNode(ASTScalarVariableNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            this.bind(node.getVariableName());
        }
    }

    @Override
    public void visitASTDataRefNode(ASTDataRefNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            if (!node.hasDerivedTypeComponentName() && node.getParent().getParent() instanceof ASTVariableNode) {
                this.bind(node.getName());
            } else if (!node.hasDerivedTypeComponentName() && node.getParent().getParent() instanceof ASTCallStmtNode) {
                this.bind(node.getName());
            } else {
                this.dontbind(node.getName());
            }
        }
        if (node.getName() != null) {
            this.dontbind(node.getName());
        }
    }

    @Override
    public void visitASTStructureComponentNode(ASTStructureComponentNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            this.bind(node.getVariableName().getVariableName());
        }
    }

    @Override
    public void visitASTFieldSelectorNode(ASTFieldSelectorNode node) {
        super.traverseChildren(node);
        this.dontbind(node.getName());
    }

    @Override
    public void visitASTArrayElementNode(ASTArrayElementNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            this.bind(node.getVariableName());
        }
    }

    @Override
    public void visitASTAllocateObjectNode(ASTAllocateObjectNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            this.bind(node.getVariableName().getVariableName());
        }
    }

    @Override
    public void visitASTPointerObjectNode(ASTPointerObjectNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName().getName());
        } else {
            IASTListNode<ASTPointerFieldNode> list = node.getPointerField();
            int i = 0;
            while (i < list.size()) {
                if (((ASTPointerFieldNode)list.get(i)).getName() != null) {
                    this.bind(((ASTPointerFieldNode)list.get(i)).getName().getName());
                }
                if (((ASTPointerFieldNode)list.get(i)).getComponentName() != null) {
                    this.dontbind(((ASTPointerFieldNode)list.get(i)).getComponentName().getName());
                }
                if (((ASTPointerFieldNode)list.get(i)).getSFDummyArgNameList() != null) {
                    int j = 0;
                    while (j < ((ASTPointerFieldNode)list.get(i)).getSFDummyArgNameList().size()) {
                        this.bind(((ASTSFDummyArgNameListNode)((ASTPointerFieldNode)list.get(i)).getSFDummyArgNameList().get(j)).getName());
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
        IASTListNode<ASTFunctionArgListNode> list;
        super.traverseChildren(node);
        if (node.getName() != null && node.getName().getName() != null && node.getName().getName().getText().trim().length() > 0) {
            this.bind(node.getName().getName());
        }
        if ((list = node.getFunctionArgList()) != null) {
            int i = 0;
            while (i < list.size()) {
                if (((ASTFunctionArgListNode)list.get(i)).getFunctionArg() != null) {
                    this.dontbind(((ASTFunctionArgListNode)list.get(i)).getFunctionArg().getName());
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTSFExprListNode(ASTSFExprListNode node) {
        super.traverseChildren(node);
        if (node.getSFDummyArgNameList() != null) {
            int j = 0;
            while (j < node.getSFDummyArgNameList().size()) {
                this.bind(((ASTSFDummyArgNameListNode)node.getSFDummyArgNameList().get(j)).getName());
                ++j;
            }
        }
    }

    @Override
    public void visitASTSFVarNameNode(ASTSFVarNameNode node) {
        super.traverseChildren(node);
        this.bind(node.getName().getName());
    }

    @Override
    public void visitASTAssignmentStmtNode(ASTAssignmentStmtNode node) {
        super.traverseChildren(node);
        this.bind(node.getLhsVariable().getName());
        if (node.getLhsNameList() != null) {
            int j = 0;
            while (j < node.getLhsNameList().size()) {
                this.bind(((ASTSFDummyArgNameListNode)node.getLhsNameList().get(j)).getName());
                ++j;
            }
        }
    }

    @Override
    public void visitASTMaskedElseWhereStmtNode(ASTMaskedElseWhereStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTElseWhereStmtNode(ASTElseWhereStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndWhereStmtNode(ASTEndWhereStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTForallTripletSpecListNode(ASTForallTripletSpecListNode node) {
        super.traverseChildren(node);
        this.bind(node.getName().getName());
    }

    @Override
    public void visitASTEndForallStmtNode(ASTEndForallStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTElseIfStmtNode(ASTElseIfStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTElseStmtNode(ASTElseStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndIfStmtNode(ASTEndIfStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTCaseStmtNode(ASTCaseStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName().getName());
        }
    }

    @Override
    public void visitASTEndSelectStmtNode(ASTEndSelectStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTLoopControlNode(ASTLoopControlNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            this.bind(node.getVariableName());
        }
    }

    @Override
    public void visitASTEndDoStmtNode(ASTEndDoStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTCycleStmtNode(ASTCycleStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTExitStmtNode(ASTExitStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTIoControlSpecNode(ASTIoControlSpecNode node) {
        super.traverseChildren(node);
        if (node.getNamelistGroupName() != null) {
            this.bind(node.getNamelistGroupName().getNamelistGroupName());
        }
    }

    @Override
    public void visitASTInputImpliedDoNode(ASTInputImpliedDoNode node) {
        super.traverseChildren(node);
        this.bind(node.getImpliedDoVariable());
    }

    @Override
    public void visitASTOutputImpliedDoNode(ASTOutputImpliedDoNode node) {
        super.traverseChildren(node);
        this.bind(node.getImpliedDoVariable());
    }

    @Override
    public void visitASTEditElementNode(ASTEditElementNode node) {
        super.traverseChildren(node);
        if (node.getIdentifier() != null) {
            this.bind(node.getIdentifier());
        }
    }

    @Override
    public void visitASTEndProgramStmtNode(ASTEndProgramStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndModuleStmtNode(ASTEndModuleStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndBlockDataStmtNode(ASTEndBlockDataStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndInterfaceStmtNode(ASTEndInterfaceStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName().getEndName());
        }
    }

    @Override
    public void visitASTModuleProcedureStmtNode(ASTModuleProcedureStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTProcedureNameListNode> list = node.getProcedureNameList();
        int i = 0;
        while (i < list.size()) {
            this.bind(((ASTProcedureNameListNode)list.get(i)).getProcedureName());
            ++i;
        }
    }

    @Override
    public void visitASTCallStmtNode(ASTCallStmtNode node) {
        IASTListNode<ASTSubroutineArgNode> list;
        super.traverseChildren(node);
        if (node.getSubroutineName() != null) {
            this.bind(node.getSubroutineName());
        }
        if ((list = node.getArgList()) != null) {
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) != null && ((ASTSubroutineArgNode)list.get(i)).getName() != null) {
                    this.dontbind(((ASTSubroutineArgNode)list.get(i)).getName());
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTFunctionParNode> list = node.getFunctionPars();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                this.bindAsParam(((ASTFunctionParNode)list.get(i)).getVariableName());
                ++i;
            }
        }
        if (node.hasResultClause()) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTEndFunctionStmtNode(ASTEndFunctionStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
        super.traverseChildren(node);
        if (node.getSubroutinePars() != null) {
            IASTListNode<ASTSubroutineParNode> list = node.getSubroutinePars();
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) != null) {
                    this.bindAsParam(((ASTSubroutineParNode)list.get(i)).getVariableName());
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTEndSubroutineStmtNode(ASTEndSubroutineStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTStmtFunctionStmtNode(ASTStmtFunctionStmtNode node) {
        super.traverseChildren(node);
        this.bind(node.getName().getName());
        if (node.getSFDummyArgNameList() != null) {
            int j = 0;
            while (j < node.getSFDummyArgNameList().size()) {
                this.bind(((ASTSFDummyArgNameListNode)node.getSFDummyArgNameList().get(j)).getName());
                ++j;
            }
        }
    }

    @Override
    public void visitASTAssignStmtNode(ASTAssignStmtNode node) {
        super.traverseChildren(node);
        this.bind(node.getVariableName());
    }

    @Override
    public void visitASTAssignedGotoStmtNode(ASTAssignedGotoStmtNode node) {
        super.traverseChildren(node);
        this.bind(node.getVariableName());
    }

    @Override
    public void visitASTDerivedTypeStmtNode(ASTDerivedTypeStmtNode node) {
        super.traverseChildren(node);
        if (node.getTypeAttrSpecList() != null) {
            for (ASTTypeAttrSpecNode spec : node.getTypeAttrSpecList()) {
                if (!spec.isExtends()) continue;
                this.bind(spec.getParentTypeName());
            }
        }
    }

    @Override
    public void visitASTSpecificBindingNode(ASTSpecificBindingNode node) {
        super.visitASTSpecificBindingNode(node);
        if (node.getInterfaceName() != null) {
            this.bind(node.getInterfaceName());
        }
        if (node.getProcedureName() != null) {
            this.setTypeBoundProcedureAttribInDefinition(this.bind(node.getProcedureName()), true);
        } else {
            this.setTypeBoundProcedureAttribInDefinition(this.bind(node.getBindingName()), false);
        }
    }

    private void setTypeBoundProcedureAttribInDefinition(List<PhotranTokenRef> definitionTokenRefs, boolean renamed) {
        for (PhotranTokenRef tokenRef : definitionTokenRefs) {
            Definition def = PhotranVPG.getInstance().getDefinitionFor(tokenRef);
            def.markAsTypeBoundProcedure(renamed);
            this.vpg.setDefinitionFor(tokenRef, def);
        }
    }

    @Override
    public void visitASTGenericBindingNode(ASTGenericBindingNode node) {
        super.visitASTGenericBindingNode(node);
        for (Token name : node.getBindingNameList()) {
            this.bind(name);
        }
    }

    @Override
    public void visitASTFinalBindingNode(ASTFinalBindingNode node) {
        super.visitASTFinalBindingNode(node);
        for (Token name : node.getFinalSubroutineNameList()) {
            this.bind(name);
        }
    }

    @Override
    public void visitASTWaitStmtNode(ASTWaitStmtNode node) {
        super.traverseChildren(node);
        for (ASTWaitSpecNode waitSpec : node.getWaitSpecList()) {
            Token variable;
            String keyword;
            if (waitSpec.getKeyword() == null || !(keyword = waitSpec.getKeyword().getText().toLowerCase()).equals("id") && !keyword.equals("iomsg") && !keyword.equals("iostat") || (variable = waitSpec.getExpr().findFirstToken()) == null || variable.getTerminal() != Terminal.T_IDENT) continue;
            this.bind(variable);
        }
    }
}

