/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PDebugModel;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointsTarget
implements IToggleBreakpointsTargetExtension {
    private UIDebugManager uiDebugManager = PTPDebugUIPlugin.getUIDebugManager();

    protected static IResource getResource(IWorkbenchPart part) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (part instanceof IEditorPart) {
            IPath location;
            IFile[] files;
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                return ((IFileEditorInput)editorInput).getFile();
            }
            ILocationProvider provider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
            if (provider != null && (files = root.findFilesForLocation(location = provider.getPath((Object)editorInput))).length > 0) {
                return files[0];
            }
        }
        return root;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = Messages.ToggleBreakpointAdapter_Operation_is_not_supported_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = Messages.ToggleBreakpointAdapter_Empty_editor_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = Messages.ToggleBreakpointAdapter_Missing_document_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IResource resource = ToggleBreakpointsTarget.getResource((IWorkbenchPart)textEditor);
        if (resource == null) {
            errorMessage = Messages.ToggleBreakpointAdapter_Missing_resource_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
        int lineNumber = bv.getValidLineBreakpointLocation(document, ((ITextSelection)selection).getStartLine());
        if (lineNumber == -1) {
            errorMessage = Messages.ToggleBreakpointAdapter_Invalid_line_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IPJob job = this.uiDebugManager.getJob();
        String sid = this.uiDebugManager.getCurrentSetId();
        sid = sid == null || sid.length() == 0 ? "Root" : sid;
        String sourceHandle = this.getSourceHandle(input);
        IPLineBreakpoint[] breakpoints = PDebugModel.lineBreakpointsExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
        if (breakpoints.length <= 0) {
            PDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true, (String)sid, (IPJob)job);
            return;
        }
        IPLineBreakpoint breakpoint = PDebugModel.lineBreakpointExists((IPLineBreakpoint[])breakpoints, (IPJob)job);
        if (breakpoint == null) {
            PDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true, (String)sid, (IPJob)job);
            return;
        }
        if (breakpoint.isGlobal() && job == null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            return;
        }
        IPSession session = PTPDebugCorePlugin.getDebugModel().getSession(job);
        if (session == null) return;
        session.getBreakpointManager().deleteBreakpoint((IPBreakpoint)breakpoint);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        PDebugUtils.println((String)"*** Not Implemented YET ***");
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    private String getSourceHandle(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProjectRelativePath().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getFullPath().toOSString();
        }
        return "";
    }

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && PTPDebugUIPlugin.getActiveWorkbenchShell() != null) {
            PTPDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    private class BreakpointLocationVerifier {
        private BreakpointLocationVerifier() {
        }

        public int getValidAddressBreakpointLocation(IDocument doc, int lineNumber) {
            return lineNumber + 1;
        }

        public int getValidLineBreakpointLocation(IDocument doc, int lineNumber) {
            return lineNumber + 1;
        }
    }
}

