/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.typehierarchy;

import java.net.URI;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.IIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.LocalCProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.LocalIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.AbstractTypeHierarchyService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraph;
import org.eclipse.ptp.rdt.core.RDTLog;

public class LocalTypeHierarchyService
extends AbstractTypeHierarchyService {
    private static ICElement findDeclaration(ICProject project, IIndex index, IASTName name, IBinding binding) throws CoreException {
        if (name != null && name.isDefinition()) {
            return IndexQueries.getCElementForName(project, index, name, (IIndexLocationConverterFactory)new LocalIndexLocationConverterFactory(), (ICProjectFactory)new LocalCProjectFactory());
        }
        ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, new LocalIndexLocationConverterFactory(), project, new LocalCProjectFactory());
        if (elems.length > 0) {
            return elems[0];
        }
        return IndexQueries.findAnyDeclaration(index, project, binding, new LocalIndexLocationConverterFactory(), new LocalCProjectFactory());
    }

    private static ICElement findDefinition(ICProject project, IIndex index, IASTName name, IBinding binding) throws CoreException {
        if (name != null && name.isDefinition()) {
            return IndexQueries.getCElementForName(project, index, name, (IIndexLocationConverterFactory)new LocalIndexLocationConverterFactory(), (ICProjectFactory)new LocalCProjectFactory());
        }
        ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, new LocalIndexLocationConverterFactory(), project, new LocalCProjectFactory());
        if (elems.length > 0) {
            return elems[0];
        }
        return IndexQueries.findAnyDeclaration(index, project, binding, new LocalIndexLocationConverterFactory(), new LocalCProjectFactory());
    }

    private static IBinding findTypeBinding(IBinding memberBinding) {
        try {
            if (memberBinding instanceof IEnumerator) {
                IType type = ((IEnumerator)memberBinding).getType();
                if (type instanceof IBinding) {
                    return (IBinding)type;
                }
            } else {
                if (memberBinding instanceof ICPPMember) {
                    return ((ICPPMember)memberBinding).getClassOwner();
                }
                if (memberBinding instanceof IField) {
                    return ((IField)memberBinding).getCompositeTypeOwner();
                }
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    public static boolean isValidInput(IBinding binding) {
        return LocalTypeHierarchyService.isValidTypeInput(binding) || binding instanceof ICPPMember || binding instanceof IEnumerator || binding instanceof IField;
    }

    public static boolean isValidInput(ICElement elem) {
        if (elem == null) {
            return false;
        }
        if (LocalTypeHierarchyService.isValidTypeInput(elem)) {
            return true;
        }
        switch (elem.getElementType()) {
            case 70: 
            case 71: 
            case 72: 
            case 81: 
            case 90: 
            case 91: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidTypeInput(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef;
    }

    public static boolean isValidTypeInput(ICElement elem) {
        if (elem == null) {
            return false;
        }
        switch (elem.getElementType()) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 80: {
                return true;
            }
        }
        return false;
    }

    public THGraph computeGraph(Scope scope, ICElement input, IProgressMonitor monitor) throws CoreException, InterruptedException {
        THGraph graph = new THGraph();
        ICProject[] projectScope = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(projectScope);
        index.acquireReadLock();
        try {
            if (monitor.isCanceled()) {
                return null;
            }
            URI locationURI = input.getLocationURI();
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(locationURI);
            String workspacePath = null;
            if (files != null && files.length > 0) {
                workspacePath = files[0].getFullPath().toString();
            }
            graph.setLocationConverterFactory(new LocalIndexLocationConverterFactory());
            graph.defineInputNode(index, input, new LocalCProjectFactory(), workspacePath);
            graph.addSuperClasses(index, monitor, new LocalCProjectFactory());
            if (monitor.isCanceled()) {
                return null;
            }
            graph.addSubClasses(index, monitor, new LocalCProjectFactory());
            if (monitor.isCanceled()) {
                return null;
            }
        }
        finally {
            index.releaseReadLock();
        }
        return graph;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement[] findInput(Scope scope, ICElement input) {
        try {
            ICProject project = CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(scope.getName());
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                IIndexName name = IndexQueries.elementToName(index, input);
                if (name == null) return null;
                input = IndexQueries.getCElementForName(project, index, name, (IIndexLocationConverterFactory)new LocalIndexLocationConverterFactory(), (ICProjectFactory)new LocalCProjectFactory());
                IIndexBinding binding = index.findBinding((IName)name);
                if (!LocalTypeHierarchyService.isValidTypeInput((IBinding)(binding = LocalTypeHierarchyService.findTypeBinding((IBinding)binding)))) return null;
                ICElement returnValue = LocalTypeHierarchyService.findDefinition(project, index, null, (IBinding)binding);
                if (returnValue == null) return null;
                ICElement[] iCElementArray = new ICElement[]{input, input};
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement[] findInput(Scope scope, ICElement memberInput, IProgressMonitor monitor) {
        try {
            ICProject project = CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(scope.getName());
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                IIndexName name = IndexQueries.elementToName(index, memberInput);
                if (name == null) return null;
                memberInput = IndexQueries.getCElementForName(project, index, name, (IIndexLocationConverterFactory)new LocalIndexLocationConverterFactory(), (ICProjectFactory)new LocalCProjectFactory());
                IIndexBinding binding = index.findBinding((IName)name);
                if (!LocalTypeHierarchyService.isValidTypeInput((IBinding)(binding = LocalTypeHierarchyService.findTypeBinding((IBinding)binding)))) return null;
                ICElement input = LocalTypeHierarchyService.findDefinition(project, index, null, (IBinding)binding);
                if (input == null) return null;
                ICElement[] iCElementArray = new ICElement[]{input, memberInput};
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement[] findInput(Scope scope, ICProject project, IWorkingCopy workingCopy, int selectionStart, int selectionLength) throws CoreException {
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                IASTName name = IndexQueries.getSelectedName(index, (ITranslationUnit)workingCopy, selectionStart, selectionLength);
                if (name == null) return null;
                IBinding binding = name.resolveBinding();
                if (!LocalTypeHierarchyService.isValidInput(binding)) {
                    return null;
                }
                ICElement member = null;
                if (!LocalTypeHierarchyService.isValidTypeInput(binding)) {
                    member = LocalTypeHierarchyService.findDeclaration(project, index, name, binding);
                    name = null;
                    binding = LocalTypeHierarchyService.findTypeBinding(binding);
                }
                if (!LocalTypeHierarchyService.isValidTypeInput(binding)) return null;
                ICElement input = LocalTypeHierarchyService.findDefinition(project, index, name, binding);
                if (input == null) return null;
                ICElement[] iCElementArray = new ICElement[]{input, member};
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement[] findInput(Scope scope, ICProject project, IWorkingCopy workingCopy, int selectionStart, int selectionLength, IProgressMonitor monitor) throws CoreException {
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                IASTName name = IndexQueries.getSelectedName(index, (ITranslationUnit)workingCopy, selectionStart, selectionLength);
                if (name == null) return null;
                IBinding binding = name.resolveBinding();
                if (!LocalTypeHierarchyService.isValidInput(binding)) {
                    return null;
                }
                ICElement member = null;
                if (!LocalTypeHierarchyService.isValidTypeInput(binding)) {
                    member = LocalTypeHierarchyService.findDeclaration(project, index, name, binding);
                    name = null;
                    binding = LocalTypeHierarchyService.findTypeBinding(binding);
                }
                if (!LocalTypeHierarchyService.isValidTypeInput(binding)) return null;
                ICElement input = LocalTypeHierarchyService.findDefinition(project, index, name, binding);
                if (input == null) return null;
                ICElement[] iCElementArray = new ICElement[]{input, member};
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }
}

