/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.internal.core.parser.ParserMessages;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

public class RemoteLogService
extends AbstractParserLogService {
    public static final String LOG_TAG = "CDTMiner";
    private DataStore fDataStore;
    private DataElement fStatus;
    private List<String> fProblemBindingMessages = new ArrayList<String>();
    private List<String> fErrorMessages = new ArrayList<String>();

    public RemoteLogService(DataStore dataStore, DataElement status) {
        this.fDataStore = dataStore;
        this.fStatus = status;
        this.generateErrorMessages();
    }

    private void generateErrorMessages() {
        this.fErrorMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.inclusionNotFound", (Object)""));
        this.fErrorMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.definitionNotFound", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.error", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.warning", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.inclusionNotFound", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.definitionNotFound", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.invalidMacroDefn", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.invalidMacroRedefn", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.unbalancedConditional", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.conditionalEval", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.macroUsage", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.circularInclusion", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.invalidDirective", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.macroPasting", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.missingRParen", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.invalidVaArgs", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.invalidEscapeChar", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.unboundedString", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.badFloatingPoint", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.badHexFormat", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.badOctalFormat", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.badDecimalFormat", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.assignmentNotAllowed", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.divideByZero", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.missingRParen", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.expressionSyntaxError", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.illegalIdentifier", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.badConditionalExpression", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.unexpectedEOF", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.scanner.badCharacter", (Object)""));
        this.fProblemBindingMessages.add(ParserMessages.getFormattedString((String)"ParserProblemFactory.error.syntax.syntaxError", (Object)""));
    }

    public void errorLog(String message) {
        UniversalServerUtilities.logError((String)LOG_TAG, (String)this.getErrorMessage(message), null, (DataStore)this.fDataStore);
    }

    protected String getErrorMessage(String message) {
        String returnMsg = message;
        if (message.indexOf("Indexer:") < 0) {
            returnMsg = "Parser Error Trace: " + message;
        } else if (this.fStatus != null) {
            int i = 0;
            while (i < this.fErrorMessages.size()) {
                if (message.indexOf(this.fErrorMessages.get(i)) > 0) {
                    this.fStatus.setAttribute(2, message);
                    this.fStatus.getDataStore().createObject(this.fStatus, "Type.Indexing.Error", message);
                    this.fStatus.getDataStore().refresh(this.fStatus);
                }
                ++i;
            }
        }
        return returnMsg;
    }

    public boolean isTracing() {
        return true;
    }

    public boolean isTracingExceptions() {
        return true;
    }

    public void traceLog(String message) {
        String logMessage = this.getTraceMessage(message);
        if (logMessage != null) {
            UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)message, (DataStore)this.fDataStore);
        }
    }

    protected String getTraceMessage(String message) {
        String returnMsg = message;
        if (message.indexOf("Indexer:") < 0) {
            returnMsg = "Parser Trace: " + message;
        } else {
            if (message.indexOf("Indexer: unresolved name") >= 0) {
                this.errorLog(message);
                return null;
            }
            boolean found = false;
            int i = 0;
            while (i < this.fProblemBindingMessages.size()) {
                if (message.indexOf(this.fProblemBindingMessages.get(i)) >= 0) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                this.errorLog(message);
                return null;
            }
        }
        return returnMsg;
    }
}

