/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.rulesengine;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.data.DownloadBackRule;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class DownloadBackAction
implements IRuleAction {
    private ILaunchProcessCallback process;
    private DownloadBackRule rule;
    private ILaunchConfiguration configuration;
    private IProgressMonitor monitor;

    public DownloadBackAction(ILaunchProcessCallback process, ILaunchConfiguration configuration, DownloadBackRule downloadBackRule, IProgressMonitor monitor) {
        this.process = process;
        this.rule = downloadBackRule;
        this.configuration = configuration;
        this.monitor = monitor;
    }

    public void run() throws CoreException {
        Assert.isNotNull((Object)this.process);
        Assert.isNotNull((Object)this.rule);
        Assert.isNotNull((Object)this.configuration);
        IRemoteFileManager remoteFileManager = this.process.getRemoteFileManager(this.configuration);
        IRemoteFileManager localFileManager = this.process.getLocalFileManager(this.configuration);
        int i = 0;
        while (i < this.rule.count()) {
            IFileStore remoteFileStore = null;
            IFileStore localFileStore = null;
            remoteFileStore = remoteFileManager.getResource(this.rule.getRemoteFile(i).toString());
            localFileStore = localFileManager.getResource(this.rule.getLocalFile(i).getAbsolutePath());
            this.doDownload(remoteFileStore, localFileStore);
            ++i;
        }
    }

    private void doDownload(IFileStore remoteFileStore, IFileStore localFileStore) throws CoreException {
        IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, this.monitor);
        if (!remoteFileInfo.exists()) {
            return;
        }
        remoteFileStore.copy(localFileStore, 2, this.monitor);
    }
}

