/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.SessionObject;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgument;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocalVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.internal.core.pdi.model.ArgumentDescriptor;
import org.eclipse.ptp.debug.internal.core.pdi.model.LocalVariableDescriptor;

public class StackFrame
extends SessionObject
implements IPDIStackFrame {
    private final IPDIThread pthread;
    private IPDIArgumentDescriptor[] argDescs;
    private IPDILocalVariableDescriptor[] localDescs;
    private final IPDILocator fLocator;
    private int level = -1;

    public StackFrame(IPDISession session, IPDIThread thread, int level, IPDILocator locator) {
        super(session, thread.getTasks());
        this.pthread = thread;
        this.level = level;
        this.fLocator = locator;
    }

    public StackFrame(IPDISession session, IPDIThread thread, int level, String file, String func, int line, BigInteger addr) {
        this(session, thread, level, PDILocationFactory.newLocator(file, func, line, addr));
    }

    public IPDIArgument createArgument(IPDIArgumentDescriptor varDesc) throws PDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.session.getVariableManager().createArgument(varDesc);
        }
        return null;
    }

    public IPDILocalVariable createLocalVariable(IPDILocalVariableDescriptor varDesc) throws PDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((IPDIArgumentDescriptor)((Object)varDesc));
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            return this.session.getVariableManager().createLocalVariable(varDesc);
        }
        return null;
    }

    public boolean equals(IPDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            boolean equal;
            StackFrame stack = (StackFrame)stackframe;
            boolean bl = equal = this.pthread != null && this.pthread.equals(stack.getThread()) && this.getLevel() == stack.getLevel();
            if (equal) {
                IPDILocator otherLocator = stack.getLocator();
                IPDILocator myLocator = this.getLocator();
                if (myLocator.equalFile(otherLocator.getFile()) && myLocator.equalFunction(otherLocator.getFunction())) {
                    return true;
                }
            }
        }
        return super.equals(stackframe);
    }

    public IPDIArgumentDescriptor[] getArgumentDescriptors() throws PDIException {
        if (this.argDescs == null) {
            this.argDescs = this.session.getVariableManager().getArgumentDescriptors(this);
        }
        return this.argDescs;
    }

    public int getLevel() {
        return this.level;
    }

    public IPDILocalVariableDescriptor[] getLocalVariableDescriptors() throws PDIException {
        if (this.localDescs == null) {
            this.localDescs = this.session.getVariableManager().getLocalVariableDescriptors(this);
        }
        return this.localDescs;
    }

    public IPDILocator getLocator() {
        if (this.fLocator != null) {
            return this.fLocator;
        }
        return PDILocationFactory.newLocator("", "", 0, BigInteger.ZERO);
    }

    public IPDITarget getTarget() {
        return this.getThread().getTarget();
    }

    public IPDIThread getThread() {
        return this.pthread;
    }

    public void stepReturn() throws PDIException {
        this.getThread().setCurrentStackFrame(this, false);
        this.session.stepReturn(this.getTasks(), 0);
    }

    public void stepReturn(IAIF aif) throws PDIException {
        this.getThread().setCurrentStackFrame(this, false);
        this.session.stepReturn(this.getTasks(), aif);
    }

    public class Arg {
        String name;
        String value;

        public Arg(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

