/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.control;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetControlEventListener;
import org.eclipse.ptp.remotetools.environment.control.ITargetControlEventProvider;
import org.eclipse.ptp.remotetools.environment.core.messages.Messages;

public class PoolingTargetControlEventProvider
implements ITargetControlEventProvider {
    public Thread monitorThread = null;
    private int monitorInterval = 4000;
    private Map controls = new HashMap();

    public void fireEvent(int status, ITargetControl control) {
        if (control != null && this.controls.containsKey(control)) {
            TargetInfo info = (TargetInfo)this.controls.get(control);
            ITargetControlEventListener listener = info.getListener();
            listener.handleStateChangeEvent(status, control);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerControlAndListener(ITargetControl control, ITargetControlEventListener listener) {
        if (control != null && !this.controls.containsKey(control)) {
            PoolingTargetControlEventProvider poolingTargetControlEventProvider = this;
            synchronized (poolingTargetControlEventProvider) {
                this.controls.put(control, new TargetInfo(listener, 1));
            }
            if (this.monitorThread == null) {
                this.monitorThread = new MonitorThread();
                this.monitorThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterControlAndListener(ITargetControl control, ITargetControlEventListener listener) {
        if (control != null && this.controls.containsKey(control)) {
            PoolingTargetControlEventProvider poolingTargetControlEventProvider = this;
            synchronized (poolingTargetControlEventProvider) {
                this.controls.remove(control);
            }
            if (this.controls.size() == 0) {
                this.monitorThread = null;
            }
        }
    }

    class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(Messages.PoolingTargetControlEventProvider_0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (PoolingTargetControlEventProvider.this.monitorThread == this) {
                PoolingTargetControlEventProvider poolingTargetControlEventProvider = PoolingTargetControlEventProvider.this;
                synchronized (poolingTargetControlEventProvider) {
                    for (ITargetControl control : PoolingTargetControlEventProvider.this.controls.keySet()) {
                        TargetInfo info;
                        int entryStatus = control.query();
                        if (entryStatus == (info = (TargetInfo)PoolingTargetControlEventProvider.this.controls.get(control)).getStatus()) continue;
                        info.setStatus(entryStatus);
                        PoolingTargetControlEventProvider.this.controls.put(control, info);
                        PoolingTargetControlEventProvider.this.fireEvent(entryStatus, control);
                    }
                }
                try {
                    MonitorThread.sleep(PoolingTargetControlEventProvider.this.monitorInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class TargetInfo {
        private int status;
        private ITargetControlEventListener listener;

        public TargetInfo(ITargetControlEventListener listener, int status) {
            this.listener = listener;
            this.status = status;
        }

        public ITargetControlEventListener getListener() {
            return this.listener;
        }

        public void setListener(ITargetControlEventListener listener) {
            this.listener = listener;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

