/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteDefaultCodeFormatterOptions;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteCodeFormattingService;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCCodeFormatter
extends CodeFormatter {
    private RemoteDefaultCodeFormatterOptions preferences;
    private Map<String, ?> options;

    public RemoteCCodeFormatter() {
        this(DefaultCodeFormatterOptions.getDefaultSettings());
    }

    public RemoteCCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public RemoteCCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, ?> options) {
        this.setOptions(options);
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public RemoteCCodeFormatter(Map<String, ?> options) {
        this(null, options);
    }

    public void setOptions(Map<String, ?> options) {
        if (options != null) {
            this.options = options;
            HashMap<String, String> formatterPrefs = new HashMap<String, String>(options.size());
            for (String key : options.keySet()) {
                Object value = options.get(key);
                if (!(value instanceof String)) continue;
                formatterPrefs.put(key, (String)value);
            }
            this.preferences = new RemoteDefaultCodeFormatterOptions(formatterPrefs);
        } else {
            this.options = CCorePlugin.getOptions();
            this.preferences = RemoteDefaultCodeFormatterOptions.getDefaultSettings();
        }
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        IFile file;
        TextEdit edit = null;
        ITranslationUnit tu = (ITranslationUnit)this.options.get("org.eclipse.cdt.core.formatter.current_translation_unit");
        if (tu == null && (file = (IFile)this.options.get("org.eclipse.cdt.core.formatter.current_file")) != null) {
            tu = (ITranslationUnit)CoreModel.getDefault().create(file);
        }
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : "\n";
        this.preferences.initial_indentation_level = indentationLevel;
        if (tu != null) {
            IRemoteCodeFormattingService codeFormattingService = this.getCodeFormattingService(tu.getCProject().getProject());
            try {
                return codeFormattingService.computeCodeFormatting(tu, source, this.preferences, offset, length, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                UIPlugin.log(e);
            }
        }
        return edit;
    }

    private IRemoteCodeFormattingService getCodeFormattingService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (!(serviceProvider instanceof IIndexServiceProvider2)) {
            return null;
        }
        IRemoteCodeFormattingService service = ((IIndexServiceProvider2)serviceProvider).getRemoteCodeFormattingService();
        return service;
    }
}

