/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ptp.internal.rdt.editor.RemoteCEditor;
import org.eclipse.ptp.internal.rdt.ui.actions.OpenViewActionGroup;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCContentOutlinePage;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCEditorHelpContextProvider;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCFoldingStructureProvider;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCSourceViewerConfiguration;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteSemanticHighlightingManager;
import org.eclipse.ptp.internal.rdt.ui.search.actions.SelectionSearchGroup;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.editor.info.IRemoteCEditorInfoProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoteCEditorInfoProvider
implements IRemoteCEditorInfoProvider {
    private RemoteCEditor editor;
    private IEditorInput input;
    private RemoteSemanticHighlightingManager fRemoteSemanticManager;
    private RemoteCFoldingStructureProvider fRemoteFoldingProvider;

    public void initializeEditor(RemoteCEditor remoteCEditor) {
        this.editor = remoteCEditor;
    }

    public void preDoSetInput(IEditorInput input) {
        this.input = input;
    }

    public void postDoSetInput(IEditorInput input) throws CoreException {
    }

    public int isApplicableEditorInput(IEditorInput input) {
        ICProject cproject = EditorUtility.getCProject((IEditorInput)input);
        if (cproject == null) {
            return 0;
        }
        IProject project = cproject.getProject();
        if (RemoteNature.hasRemoteNature((IProject)project)) {
            return 1;
        }
        return 0;
    }

    public Image getTitleImage() {
        return null;
    }

    public IDocumentProvider getDocumentProvider(IDocumentProvider oldProvider) {
        return null;
    }

    public String getTitle(IEditorInput input) {
        return null;
    }

    public IEditorInput getAlternateInput(IEditorInput input) {
        return null;
    }

    public String getTitleTooltip() {
        return null;
    }

    public CContentOutlinePage getOutlinePage(RemoteCEditor remoteCEditor) {
        if (this.isRemote()) {
            return new RemoteCContentOutlinePage((CEditor)remoteCEditor);
        }
        return null;
    }

    public void doPostCreatePartControl(Composite parent) {
        if (this.isRemote()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ptp.rdt.ui.remote_C_CPP_editor_context");
        }
    }

    public Object getAdapter(Class required) {
        if (IContextProvider.class.equals((Object)required)) {
            return new RemoteCEditorHelpContextProvider((ITextEditor)this.editor);
        }
        return null;
    }

    public boolean doPrePerformSave(boolean overwrite) {
        return true;
    }

    public void doPostPerformSave() {
    }

    public void createActions(IVerticalRuler iVerticalRuler) {
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        if (this.isRemote()) {
            menu.remove("org.eclipse.search.text.ctxmenu");
            menu.remove("org.eclipse.cdt.ui.refactoring.menu");
            IMenuManager sourceMenu = (IMenuManager)menu.find("org.eclipse.cdt.ui.source.menu");
            if (sourceMenu != null) {
                sourceMenu.remove("AddIncludeOnSelection");
                sourceMenu.remove("org.eclipse.cdt.ui.refactor.getters.and.setters");
                sourceMenu.remove("org.eclipse.cdt.ui.refactor.implement.method");
            }
            menu.remove("OpenMacroExplorer");
            menu.remove("ToggleSourceHeader");
            menu.remove("OpenHierarchy");
        }
    }

    public void dispose() {
        this.uninstallRemoteCodeFolding();
    }

    public int getAnnotationRulerColumnWidth() {
        return 0;
    }

    public void helpRequested(HelpEvent e) {
    }

    public void createUndoRedoActions() {
    }

    public void doPreRevertToSaved() {
    }

    public void doPostRevertToSaved() {
    }

    public void aboutToBeReconciled() {
    }

    public ICElement getInputCElement() {
        return null;
    }

    public boolean reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        return true;
    }

    public boolean doPrePerformSaveAs(IProgressMonitor progressMonitor) {
        return true;
    }

    public void doPostPerformSaveAs() {
    }

    public boolean validateState(IEditorInput input) {
        return true;
    }

    public void rulerContextMenuAboutToShow(IMenuManager menu) {
    }

    public String[] collectContextMenuPreferencePages() {
        return null;
    }

    public ActionGroup createSelectionSearchGroup(RemoteCEditor remoteCEditor) {
        return new SelectionSearchGroup((CEditor)remoteCEditor);
    }

    public ActionGroup createOpenViewActionGroup(RemoteCEditor remoteCEditor) {
        return new OpenViewActionGroup((ITextEditor)remoteCEditor);
    }

    private boolean isRemote() {
        ICElement element = this.editor.getInputCElement();
        if (element == null) {
            return false;
        }
        ICProject cProject = element.getCProject();
        if (cProject == null) {
            return false;
        }
        IProject project = cProject.getProject();
        return RemoteNature.hasRemoteNature((IProject)project);
    }

    private boolean isLocalServiceProvider() {
        IService indexingService;
        IServiceConfiguration serviceConfig;
        IServiceProvider serviceProvider;
        ICProject cproject = EditorUtility.getCProject((IEditorInput)this.input);
        if (cproject == null) {
            return true;
        }
        ServiceModelManager smm = ServiceModelManager.getInstance();
        if (smm.isConfigured(cproject.getProject()) && (serviceProvider = (serviceConfig = smm.getActiveConfiguration(cproject.getProject())).getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"))) instanceof IIndexServiceProvider) {
            return !((IIndexServiceProvider)serviceProvider).isRemote();
        }
        return !RemoteNature.hasRemoteNature((IProject)cproject.getProject());
    }

    public SourceViewerConfiguration getSourceViewerConfiguration(IPreferenceStore store, SourceViewerConfiguration sourceViewerConfiguration) {
        if (!this.isLocalServiceProvider() && !(sourceViewerConfiguration instanceof RemoteCSourceViewerConfiguration)) {
            CTextTools textTools = CUIPlugin.getDefault().getTextTools();
            return new RemoteCSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this.editor, "___c_partitioning");
        }
        return null;
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.isRemote()) {
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Rename", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ExtractConstant", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ExtractLocalVariable", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ExtractMethod", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.HideMethod", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.GettersAndSetters", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ImplementMethod", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.AddInclude", null);
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.SortLines", null);
        }
    }

    public boolean shouldProcessLocalParsingCompletions() {
        return this.isLocalServiceProvider();
    }

    public void installSemanticHighlighting(ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        if (!this.isLocalServiceProvider() && this.fRemoteSemanticManager == null && this.isSemanticHighlightingEnabled(prefStore)) {
            this.fRemoteSemanticManager = new RemoteSemanticHighlightingManager();
            this.fRemoteSemanticManager.install(this.editor, (CSourceViewer)sourceViewer, CUIPlugin.getDefault().getTextTools().getColorManager(), prefStore);
        } else if (this.isLocalServiceProvider()) {
            this.uninstallSemanticHighlighting();
        }
    }

    public void refreshRemoteSemanticManager() {
        if (this.fRemoteSemanticManager != null) {
            this.fRemoteSemanticManager.refresh();
        }
    }

    public boolean isSemanticHighlightingEnabled(IPreferenceStore prefStore) {
        return SemanticHighlightings.isEnabled((IPreferenceStore)prefStore) && (!this.editor.isEnableScalablilityMode() || !prefStore.getBoolean("scalability.semanticHighlight"));
    }

    public void installRemoteCodeFolding(ISourceViewer sourceViewer) {
        String id = CUIPlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        if (id.compareTo("org.eclipse.cdt.ui.text.defaultFoldingProvider") == 0 && !this.isLocalServiceProvider()) {
            this.editor.uninstallProjectionModelUpdater();
            this.fRemoteFoldingProvider = new RemoteCFoldingStructureProvider();
            ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
            this.fRemoteFoldingProvider.install((ITextEditor)this.editor, projectionViewer);
        }
    }

    public void uninstallRemoteCodeFolding() {
        if (this.fRemoteFoldingProvider != null) {
            this.fRemoteFoldingProvider.uninstall();
        }
    }

    public void uninstallSemanticHighlighting() {
        if (this.fRemoteSemanticManager != null) {
            this.fRemoteSemanticManager.uninstall();
            this.fRemoteSemanticManager = null;
        }
    }
}

