/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.navigation;

import java.io.Serializable;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.model.ICElement;

public class OpenDeclarationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object result;
    private final ResultType resultType;

    public static OpenDeclarationResult resultNames(IName[] names) {
        return new OpenDeclarationResult(ResultType.RESULT_NAMES, names);
    }

    public static OpenDeclarationResult resultCElements(ICElement[] elements) {
        return new OpenDeclarationResult(ResultType.RESULT_C_ELEMENTS, elements);
    }

    public static OpenDeclarationResult resultIncludePath(String path) {
        return new OpenDeclarationResult(ResultType.RESULT_INCLUDE_PATH, path);
    }

    public static OpenDeclarationResult resultName(IName name) {
        return new OpenDeclarationResult(ResultType.RESULT_NAME, name);
    }

    public static OpenDeclarationResult resultLocation(IASTFileLocation location) {
        return new OpenDeclarationResult(ResultType.RESULT_LOCATION, location);
    }

    public static OpenDeclarationResult failureSymbolLookup(String symbolName) {
        return new OpenDeclarationResult(ResultType.FAILURE_SYMBOL_LOOKUP, symbolName);
    }

    public static OpenDeclarationResult failureIncludeLookup(String path) {
        return new OpenDeclarationResult(ResultType.FAILURE_INCLUDE_LOOKUP, path);
    }

    public static OpenDeclarationResult failureUnexpectedError() {
        return new OpenDeclarationResult(ResultType.FAILURE_UNEXPECTED_ERROR);
    }

    private OpenDeclarationResult(ResultType resultType, Object result) {
        if (result == null) {
            throw new NullPointerException();
        }
        this.result = result;
        this.resultType = resultType;
    }

    private OpenDeclarationResult(ResultType resultType) {
        this.result = null;
        this.resultType = resultType;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public Object getResult() {
        return this.result;
    }

    public String toString() {
        return (Object)((Object)this.resultType) + ": " + String.valueOf(this.result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        RESULT_NAMES,
        RESULT_C_ELEMENTS,
        RESULT_INCLUDE_PATH,
        RESULT_NAME,
        RESULT_LOCATION,
        FAILURE_SYMBOL_LOOKUP,
        FAILURE_INCLUDE_LOOKUP,
        FAILURE_UNEXPECTED_ERROR;

    }
}

