#!/bin/sh
#*******************************************************************************
# Copyright (c) 2005, 2008 IBM Corporation, Wind River Systems, Inc. and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# IBM Corporation - initial API and implementation
# Martin Oberhuber (Wind River) - Fix for solaris (Bourne Shell export statement)
# Patrick Juhl - Fix for unix (Parameters for port selection)
# David McKnight (IBM) - Fix to handle timeout and clientUserID parameters
#*******************************************************************************
# Shell script to start an RSE communications server
# This script will start the datastore server listening on an available socket
serverpath=.;

CLASSPATH=.:dstore_extra_server.jar:dstore_core.jar:dstore_miners.jar:clientserver.jar:cdtminer.jar:cdtmodel.jar:cdtparser.jar:org.eclipse.core.runtime_3.6.0.v20100505.jar:org.eclipse.equinox.common_3.6.0.v20100503.jar:org.eclipse.core.filesystem_1.3.1.R36x_v20100727-0745.jar:com.ibm.icu.base_4.2.1.v20100412.jar:org.eclipse.text_3.5.0.v20100601-1300.jar:stubs.jar:lrparser.jar:upcparser.jar:xlcparser.jar:spawner.jar:net.sourceforge.lpg.lpgjavaruntime_1.1.0.v200803061910.jar:$CLASSPATH;
export serverpath CLASSPATH


port=0;
timeout=60000;
clientUserID=$USER;

if [ $# -gt 2 ]; then
  clientUserID=$3
fi 
if [ $# -gt 1 ]; then 
  timeout=$2
fi
if [ $# -gt 0 ]; then
  port=$1
fi

case x$port in
  x-h*) echo "Usage: server.sh [port] [timeout] [clientUserId]"
        exit 0
        ;;
esac

java -Xms64m -Xmx128m -Xss2m -DA_PLUGIN_PATH=$serverpath -DDSTORE_TRACING_ON=false -Dclient.username=$clientUserID -DDSTORE_SPIRIT_ON=true org.eclipse.dstore.core.server.Server $port $timeout &

