/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.hover;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.hover.FortranHoverASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.hover.SourceViewerInformationControl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranDeclarationHover
implements ITextHover,
ITextHoverExtension {
    private FortranEditor fEditor;
    private boolean hoverTipEnabled;
    private TokenList activeTokenList = null;
    private DefinitionMap<Definition> activeDefinitionMap = null;

    public void setTokenList(TokenList tokenList) {
        this.activeTokenList = tokenList;
    }

    public void setDefinitionMap(DefinitionMap<Definition> defMap) {
        this.activeDefinitionMap = defMap;
    }

    public FortranDeclarationHover(ISourceViewer sourceViewer, FortranEditor editor) {
        Assert.isNotNull((Object)sourceViewer);
        this.fEditor = editor;
        if (editor == null) {
            return;
        }
        this.hoverTipEnabled = new SearchPathProperties().getProperty(editor.getIFile(), "EnableHoverTip").equals("true");
        FortranEditorTasks instance = FortranEditorTasks.instance(editor);
        instance.addASTTask(new FortranHoverASTTask(this, this.hoverTipEnabled));
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String str = "";
        if (this.activeTokenList != null && this.activeDefinitionMap != null) {
            try {
                TextSelection ts = new TextSelection(textViewer.getDocument(), hoverRegion.getOffset(), hoverRegion.getLength());
                Definition def = this.activeDefinitionMap.lookup(ts, this.activeTokenList);
                if (def != null) {
                    str = def.describe();
                }
            }
            catch (Throwable throwable) {}
        }
        return str;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.hoverTipEnabled) {
            return this.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                FortranEditor editor = FortranDeclarationHover.this.fEditor;
                int orientation = 0;
                if (editor instanceof IWorkbenchPartOrientation) {
                    orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                SourceViewerInformationControl sv = new SourceViewerInformationControl(parent, false, orientation, EditorsUI.getTooltipAffordanceString());
                return sv;
            }
        };
    }

    private IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        start = this.getOffsetOfWord(offset, document, -1);
        end = this.getOffsetOfWord(offset, document, 1);
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    private int getOffsetOfWord(int current, IDocument document, int direction) {
        int length = document.getLength();
        while (current >= 0 && current < length) {
            try {
                char c = document.getChar(current);
                if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                current += direction;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return current;
    }
}

