/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.debug.core.IPLocationSetManager;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.event.PDebugInfo;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.model.IPLocationSet;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocatorComparator;
import org.eclipse.ptp.debug.core.pdi.event.IPDIBreakpointInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDestroyedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDisconnectedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEndSteppingRangeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.event.IPDIExitInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIFunctionFinishedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDILocationReachedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDISharedLibraryInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISignalInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISuspendedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointScopeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointTriggerInfo;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocationBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrameDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListStackFramesRequest;

public class PLocationSetManager
implements IPLocationSetManager,
IPDIEventListener {
    private final IPSession session;
    private final Map<IPDILocator, IPLocationSet> setsByLocation;

    public PLocationSetManager(IPSession session) {
        this.session = session;
        this.setsByLocation = new TreeMap<IPDILocator, IPLocationSet>(PDILocatorComparator.SINGLETON);
        this.getPDISession().getEventManager().addEventListener(this);
    }

    public void dispose(IProgressMonitor monitor) {
        this.getPDISession().getEventManager().removeEventListener(this);
    }

    public IPLocationSet[] getLocationSets() {
        return this.setsByLocation.values().toArray(new IPLocationSet[0]);
    }

    public IPSession getSession() {
        return this.session;
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPDIEvent event = events[i];
            if (event instanceof IPDISuspendedEvent) {
                this.handleSuspendedEvent((IPDISuspendedEvent)event);
            } else if (event instanceof IPDIResumedEvent) {
                this.handleResumedEvent((IPDIResumedEvent)event);
            } else if (event instanceof IPDIDestroyedEvent) {
                this.handleDestroyedEvent((IPDIDestroyedEvent)event);
            } else if (event instanceof IPDIDisconnectedEvent) {
                this.handleDisconnectedEvent((IPDIDisconnectedEvent)event);
            }
            ++i;
        }
    }

    private IPDISession getPDISession() {
        return this.getSession().getPDISession();
    }

    private void handleDestroyedEvent(IPDIDestroyedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIExitInfo) {
            this.setsByLocation.clear();
        }
    }

    private void handleDisconnectedEvent(IPDIDisconnectedEvent event) {
        this.setsByLocation.clear();
    }

    private void handleResumedEvent(IPDIResumedEvent event) {
        TaskSet tasks = event.getTasks();
        int[] members = tasks.toArray();
        for (IPLocationSet ls : this.setsByLocation.values()) {
            ls.getTasks().clear(members);
        }
        Iterator<IPDILocator> iter = this.setsByLocation.keySet().iterator();
        while (iter.hasNext()) {
            IPDILocator loc = iter.next();
            if (this.setsByLocation.get(loc).getTasks().cardinality() != 0) continue;
            iter.remove();
        }
        this.session.fireDebugEvent(16, 512, new PDebugLocationInfo(this.session.getLaunch(), event.getTasks(), event.getTasks(), event.getTasks()));
    }

    private void handleSuspendedEvent(IPDISuspendedEvent event) {
        IPDISessionObject reason = event.getReason();
        IPDILocator locator = null;
        if (reason instanceof IPDIBreakpointInfo) {
            IPDIBreakpoint bp = ((IPDIBreakpointInfo)reason).getBreakpoint();
            if (bp instanceof IPDILocationBreakpoint) {
                locator = ((IPDILocationBreakpoint)bp).getLocator();
                try {
                    TaskSet tasks = event.getTasks();
                    assert (!tasks.isEmpty());
                    TaskSet onetask = new TaskSet(tasks.taskSize());
                    onetask.set(tasks.nextSetBit(0));
                    IPDISession session = reason.getSession();
                    IPDIListStackFramesRequest request = session.getRequestFactory().getListStackFramesRequest(session, onetask, 0, 1);
                    session.getEventRequestManager().addEventRequest(request);
                    IPDIStackFrameDescriptor[] frames = request.getStackFrames(tasks);
                    locator = frames[0].getLocator();
                }
                catch (PDIException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (reason instanceof IPDIEndSteppingRangeInfo) {
            locator = ((IPDIEndSteppingRangeInfo)reason).getLocator();
        } else if (reason instanceof IPDILocationReachedInfo) {
            locator = ((IPDILocationReachedInfo)reason).getLocator();
        } else if (reason instanceof IPDISignalInfo) {
            locator = ((IPDISignalInfo)reason).getLocator();
        } else if (reason instanceof IPDIFunctionFinishedInfo) {
            locator = ((IPDIFunctionFinishedInfo)reason).getLocator();
        } else if (reason instanceof IPDISharedLibraryInfo || reason instanceof IPDIWatchpointScopeInfo || reason instanceof IPDIWatchpointTriggerInfo) {
            // empty if block
        }
        if (locator != null) {
            TaskSet tasks = event.getTasks();
            int[] members = tasks.toArray();
            for (IPLocationSet ls : this.setsByLocation.values()) {
                ls.getTasks().clear(members);
            }
            Iterator<IPDILocator> iter = this.setsByLocation.keySet().iterator();
            while (iter.hasNext()) {
                IPDILocator loc = iter.next();
                if (this.setsByLocation.get(loc).getTasks().cardinality() != 0) continue;
                iter.remove();
            }
            if (this.setsByLocation.containsKey(locator)) {
                this.setsByLocation.get(locator).getTasks().set(members);
            } else {
                this.setsByLocation.put(locator, new PLocationSet(tasks, locator));
            }
        }
        this.session.fireDebugEvent(16, 512, new PDebugLocationInfo(this.session.getLaunch(), event.getTasks(), event.getTasks(), event.getTasks()));
    }

    public static class PDebugLocationInfo
    extends PDebugInfo {
        public PDebugLocationInfo(IPLaunch launch, TaskSet allTasks, TaskSet allRegTasks, TaskSet allUnregTasks) {
            super(launch, allTasks, allRegTasks, allUnregTasks);
        }
    }

    public static final class PLocationSet
    implements IPLocationSet {
        public final TaskSet fTasks;
        public final IPDILocator fLocator;

        public PLocationSet(TaskSet tasks, IPDILocator locator) {
            this.fTasks = tasks;
            this.fLocator = locator;
        }

        public String getFile() {
            return this.fLocator.getFile();
        }

        public String getFunction() {
            return this.fLocator.getFunction();
        }

        public int getLineNumber() {
            return this.fLocator.getLineNumber();
        }

        public TaskSet getTasks() {
            return this.fTasks;
        }
    }
}

