/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.papiselect.papic;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ptp.etfw.tau.papiselect.papic.ETItem;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventSet;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventTree;
import org.eclipse.ptp.etfw.tau.papiselect.papic.PapiInfoParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapiCSelect {
    PapiInfoParser pparser;
    String toolPath;
    private static final String papiApp = "papi_xml_event_info";
    SAXParser sp;

    PapiCSelect(String tpath) {
        this.toolPath = String.valueOf(tpath) + File.separator + papiApp;
        try {
            this.sp = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.pparser = new PapiInfoParser();
    }

    private EventTree parseETree(InputStream is) {
        this.sp.reset();
        try {
            this.sp.parse(is, (DefaultHandler)this.pparser);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.pparser.getEventTree();
    }

    public EventTree getEventTree() {
        EventTree et = null;
        try {
            this.pparser.reset();
            et = this.findET(new String[]{this.toolPath});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return et;
    }

    public EventTree findET(String[] commands) {
        EventTree et = null;
        try {
            Process p = Runtime.getRuntime().exec(commands);
            OutReader errThd = new OutReader(p.getErrorStream());
            OutReader stdThd = new OutReader(p.getInputStream());
            stdThd.start();
            errThd.start();
            int result = p.waitFor();
            stdThd.join();
            errThd.join();
            p.destroy();
            if (result == 0) {
                byte[] xbytes = stdThd.str.toString().getBytes();
                ByteArrayInputStream stringIS = new ByteArrayInputStream(xbytes);
                et = this.parseETree(stringIS);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return et;
    }

    public Set<Integer>[] getAvailable(int component, Set<String> checked) {
        HashSet[] index = new HashSet[2];
        this.pparser.reset();
        ArrayList<String> cAl = new ArrayList<String>(checked);
        cAl.add(0, String.valueOf(component));
        cAl.add(0, "-c");
        cAl.add(0, this.toolPath);
        String[] a = new String[cAl.size()];
        cAl.toArray(a);
        EventTree et = this.findET(a);
        if (et == null) {
            return null;
        }
        index[0] = ((EventSet)((ETItem)et.children.get((int)0)).children.get((int)0)).fullSet;
        index[1] = ((EventSet)((ETItem)et.children.get((int)0)).children.get((int)1)).fullSet;
        return index;
    }

    public class OutReader
    extends Thread {
        StringBuffer str = new StringBuffer();
        BufferedReader out;

        OutReader(InputStream is) {
            this.out = new BufferedReader(new InputStreamReader(is));
        }

        public void run() {
            try {
                String s;
                while ((s = this.out.readLine()) != null) {
                    this.str.append(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

