/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IChangedNodeEvent;
import org.eclipse.ptp.core.elements.events.INewNodeEvent;
import org.eclipse.ptp.core.elements.events.IRemoveNodeEvent;
import org.eclipse.ptp.core.elements.listeners.IMachineChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.listeners.IResourceManagerListener;
import org.eclipse.ptp.internal.core.elements.PJob;
import org.eclipse.ptp.internal.core.elements.PMachine;
import org.eclipse.ptp.internal.core.elements.PNode;
import org.eclipse.ptp.internal.core.elements.PQueue;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedMachineEvent;
import org.eclipse.ptp.internal.core.elements.events.ChangedQueueEvent;
import org.eclipse.ptp.internal.core.elements.events.NewJobEvent;
import org.eclipse.ptp.internal.core.elements.events.NewMachineEvent;
import org.eclipse.ptp.internal.core.elements.events.NewQueueEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveJobEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveMachineEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveQueueEvent;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PResourceManager
extends Parent
implements IPResourceManager {
    private final ListenerList childListeners = new ListenerList();
    private final IResourceManager fResourceManager;
    private final ListenerList listeners = new ListenerList();
    private final IMachineChildListener machineNodeListener;
    private final Map<String, IPJob> jobsById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPMachine> machinesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPNode> nodesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPQueue> queuesById = Collections.synchronizedMap(new HashMap());

    private static IAttribute<?, ?, ?>[] getDefaultAttributes(IResourceManagerConfiguration config) {
        ArrayList<AbstractAttribute> attrs = new ArrayList<AbstractAttribute>();
        attrs.add(ElementAttributes.getNameAttributeDefinition().create(config.getName()));
        attrs.add(ElementAttributes.getIdAttributeDefinition().create(config.getUniqueName()));
        attrs.add(ResourceManagerAttributes.getDescriptionAttributeDefinition().create(config.getDescription()));
        attrs.add(ResourceManagerAttributes.getTypeAttributeDefinition().create(config.getType()));
        attrs.add(ResourceManagerAttributes.getStateAttributeDefinition().create(ResourceManagerAttributes.State.STOPPED));
        attrs.add(ResourceManagerAttributes.getRmIDAttributeDefinition().create(config.getUniqueName()));
        return attrs.toArray(new IAttribute[0]);
    }

    public PResourceManager(IPUniverse universe, IResourceManager rm) {
        super(universe.getNextResourceManagerId(), universe, PResourceManager.getDefaultAttributes(rm.getConfiguration()));
        this.fResourceManager = rm;
        this.machineNodeListener = new IMachineChildListener(){

            public void handleEvent(IChangedNodeEvent e) {
            }

            public void handleEvent(INewNodeEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(IRemoveNodeEvent e) {
                Map map = PResourceManager.this.nodesById;
                synchronized (map) {
                    for (IPNode node : e.getNodes()) {
                        PResourceManager.this.nodesById.remove(node.getID());
                    }
                }
            }
        };
    }

    @Override
    public void addChildListener(IResourceManagerChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    public void addElementListener(IResourceManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addJobAttributes(Collection<IPJob> jobs, IAttribute<?, ?, ?>[] attrs) {
        for (IPJob job : jobs) {
            job.addAttributes(attrs);
        }
    }

    @Override
    public void addJobs(IPQueue queue, Collection<IPJob> jobs) {
        HashMap map = new HashMap();
        for (IPJob iPJob : jobs) {
            IPQueue jQueue;
            ArrayList qJobs;
            StringAttribute queueIdAttr = (StringAttribute)iPJob.getAttribute(JobAttributes.getQueueIdAttributeDefinition());
            if (queueIdAttr != null && (qJobs = (ArrayList)map.get(jQueue = this.getQueueById(queueIdAttr.getValue()))) == null) {
                qJobs = new ArrayList();
                map.put(queue, qJobs);
            }
            this.jobsById.put(iPJob.getID(), iPJob);
        }
        for (Map.Entry entry : map.entrySet()) {
            ((IPQueue)entry.getKey()).addJobs((Collection)entry.getValue());
        }
        if (queue != null) {
            queue.addJobs(jobs);
        }
        this.fireNewJobs(jobs);
    }

    @Override
    public void addMachineAttributes(Collection<IPMachine> machines, IAttribute<?, ?, ?>[] attrs) {
        for (IPMachine machine : machines) {
            machine.addAttributes(attrs);
        }
        this.fireChangedMachines(machines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMachines(Collection<IPMachine> machines) {
        Map<String, IPMachine> map = this.machinesById;
        synchronized (map) {
            for (IPMachine machine : machines) {
                this.machinesById.put(machine.getID(), machine);
                machine.addChildListener(this.machineNodeListener);
            }
        }
        this.fireNewMachines(machines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodes(IPMachine machine, Collection<IPNode> nodes) {
        Map<String, IPNode> map = this.nodesById;
        synchronized (map) {
            for (IPNode node : nodes) {
                this.nodesById.put(node.getID(), node);
            }
        }
        machine.addNodes(nodes);
    }

    @Override
    public void addProcessesByJobRanks(IPJob job, BitSet processJobRanks, AttributeManager attrs) {
        job.addProcessesByJobRanks(processJobRanks, attrs);
        Set nodeIdAttrs = job.getProcessAttributes(ProcessAttributes.getNodeIdAttributeDefinition(), processJobRanks);
        for (StringAttribute nodeIdAttr : nodeIdAttrs) {
            IPNode node = this.getNodeById(nodeIdAttr.getValue());
            if (node == null) continue;
            BitSet nodesProcessJobRanks = job.getProcessJobRanks(nodeIdAttr);
            node.addJobProcessRanks(job, nodesProcessJobRanks);
        }
    }

    @Override
    public void addQueueAttributes(Collection<IPQueue> queues, IAttribute<?, ?, ?>[] attrs) {
        for (IPQueue queue : queues) {
            queue.addAttributes(attrs);
        }
        this.fireChangedQueues(queues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueues(Collection<IPQueue> queues) {
        Map<String, IPQueue> map = this.queuesById;
        synchronized (map) {
            for (IPQueue queue : queues) {
                this.queuesById.put(queue.getID(), queue);
            }
        }
        this.fireNewQueues(queues);
    }

    public void dispose() {
        this.listeners.clear();
        this.childListeners.clear();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter == IPResourceManager.class) {
            return this;
        }
        if (adapter == IResourceManager.class) {
            return this.fResourceManager;
        }
        if (adapter == IResourceManagerConfiguration.class) {
            return this.fResourceManager.getConfiguration();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String getID() {
        return super.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPJob getJobById(String id) {
        Map<String, IPJob> map = this.jobsById;
        synchronized (map) {
            return this.jobsById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPJob[] getJobs() {
        Map<String, IPJob> map = this.jobsById;
        synchronized (map) {
            return this.jobsById.values().toArray(new IPJob[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPMachine getMachineById(String id) {
        Map<String, IPMachine> map = this.machinesById;
        synchronized (map) {
            return this.machinesById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPMachine[] getMachines() {
        Map<String, IPMachine> map = this.machinesById;
        synchronized (map) {
            return this.machinesById.values().toArray(new IPMachine[0]);
        }
    }

    @Override
    public String getName() {
        return this.fResourceManager.getConfiguration().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPNode getNodeById(String id) {
        Map<String, IPNode> map = this.nodesById;
        synchronized (map) {
            return this.nodesById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPQueue getQueueById(String id) {
        Map<String, IPQueue> map = this.queuesById;
        synchronized (map) {
            return this.queuesById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPQueue[] getQueues() {
        Map<String, IPQueue> map = this.queuesById;
        synchronized (map) {
            return this.queuesById.values().toArray(new IPQueue[0]);
        }
    }

    @Override
    public IResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    @Override
    public IPJob newJob(String jobId, AttributeManager attrs) {
        return new PJob(jobId, this.fResourceManager, this, attrs.getAttributes());
    }

    @Override
    public IPMachine newMachine(String machineId, AttributeManager attrs) {
        return new PMachine(machineId, this.fResourceManager, this, attrs.getAttributes());
    }

    @Override
    public IPNode newNode(IPMachine machine, String nodeId, AttributeManager attrs) {
        return new PNode(nodeId, machine, attrs.getAttributes());
    }

    @Override
    public IPQueue newQueue(String queueId, AttributeManager attrs) {
        return new PQueue(queueId, this.fResourceManager, this, attrs.getAttributes());
    }

    @Override
    public void removeChildListener(IResourceManagerChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    public void removeElementListener(IResourceManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobs(Collection<IPJob> jobs) {
        Map<String, IPJob> map = this.jobsById;
        synchronized (map) {
            for (IPJob job : jobs) {
                job.removeProcessesByJobRanks(job.getProcessJobRanks());
                this.jobsById.remove(job.getID());
            }
        }
        IPQueue[] iPQueueArray = this.getQueues();
        int n = iPQueueArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPQueue queue = iPQueueArray[n2];
            queue.removeJobs(jobs);
            ++n2;
        }
        this.fireRemoveJobs(jobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMachines(Collection<IPMachine> machines) {
        Map<String, IPMachine> map = this.machinesById;
        synchronized (map) {
            for (IPMachine machine : machines) {
                machine.removeNodes(Arrays.asList(machine.getNodes()));
                machine.removeChildListener(this.machineNodeListener);
                this.machinesById.remove(machine.getID());
            }
        }
        this.fireRemoveMachines(machines);
    }

    @Override
    public void removeNodes(IPMachine machine, Collection<IPNode> nodes) {
        machine.removeNodes(nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueues(Collection<IPQueue> queues) {
        Map<String, IPQueue> map = this.queuesById;
        synchronized (map) {
            for (IPQueue queue : queues) {
                queue.removeJobs(Arrays.asList(queue.getJobs()));
                this.queuesById.remove(queue.getID());
            }
        }
        this.fireRemoveQueues(queues);
    }

    @Override
    public void removeTerminatedJobs() {
        ArrayList<IPJob> terminatedJobs = new ArrayList<IPJob>();
        IPJob[] iPJobArray = this.getJobs();
        int n = iPJobArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPJob job = iPJobArray[n2];
            if (job.getState() == JobAttributes.State.COMPLETED) {
                terminatedJobs.add(job);
            }
            ++n2;
        }
        this.removeJobs(terminatedJobs);
    }

    public synchronized void setState(ResourceManagerAttributes.State state) {
        this.getResourceManager().setState(state.name());
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        StringAttribute nameAttr = (StringAttribute)attrs.getAttribute(ElementAttributes.getNameAttributeDefinition());
        if (nameAttr != null) {
            this.fResourceManager.getConfiguration().setName(nameAttr.getValue());
        }
    }

    protected void fireChangedMachines(Collection<IPMachine> machines) {
        ChangedMachineEvent e = new ChangedMachineEvent(this, machines);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireChangedQueues(Collection<IPQueue> queues) {
        ChangedQueueEvent e = new ChangedQueueEvent(this, queues);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireNewJobs(Collection<IPJob> jobs) {
        NewJobEvent e = new NewJobEvent(this, jobs);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireNewMachines(Collection<IPMachine> machines) {
        NewMachineEvent e = new NewMachineEvent(this, machines);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireNewQueues(Collection<IPQueue> queues) {
        NewQueueEvent e = new NewQueueEvent(this, queues);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireRemoveJobs(Collection<IPJob> jobs) {
        RemoveJobEvent e = new RemoveJobEvent(this, jobs);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireRemoveMachines(Collection<IPMachine> machines) {
        RemoveMachineEvent e = new RemoveMachineEvent(this, machines);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireRemoveQueues(Collection<IPQueue> queues) {
        RemoveQueueEvent e = new RemoveQueueEvent(this, queues);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected CoreException makeCoreException(String string) {
        Status status = new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, string, null);
        return new CoreException((IStatus)status);
    }
}

