/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.analysis.flow;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rephraserengine.core.analysis.flow.BasicBlock;
import org.eclipse.rephraserengine.core.analysis.flow.FlowGraph;
import org.eclipse.rephraserengine.core.analysis.flow.FlowGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBlockBuilder<U> {
    private FlowGraph<U> cfg;
    private Map<FlowGraphNode<U>, FlowGraphNode<BasicBlock<U>>> newNodes;

    FlowGraph<BasicBlock<U>> buildFlowGraphFrom(FlowGraph<U> cfg) {
        this.cfg = cfg;
        this.newNodes = new HashMap<FlowGraphNode<U>, FlowGraphNode<BasicBlock<U>>>();
        this.constructNewNodes();
        this.connectNewNodes();
        return new FlowGraph<BasicBlock<U>>(this.newNodes.get(cfg.getEntryNode()), this.newNodes.get(cfg.getExitNode()));
    }

    private void constructNewNodes() {
        FlowGraphNode<BasicBlock<U>> currentNode = null;
        for (FlowGraphNode<U> node : this.cfg.nodesInPreOrder()) {
            if (currentNode == null || node.getPrecedessors().size() != 1 || this.isGoToOrStop(node.getPrecedessors().get(0).getData())) {
                currentNode = new FlowGraphNode<BasicBlock<U>>(node.getName(), new BasicBlock<U>(node.getData()));
            } else {
                currentNode.getData().add(node.getData());
            }
            this.newNodes.put(node, currentNode);
            if (node.getSuccessors().size() == 1) continue;
            currentNode = null;
        }
    }

    private void connectNewNodes() {
        for (FlowGraphNode<U> node : this.cfg.nodesInPreOrder()) {
            FlowGraphNode<BasicBlock<U>> nodeBB = this.newNodes.get(node);
            for (FlowGraphNode<U> succ : node.getSuccessors()) {
                FlowGraphNode<BasicBlock<U>> succBB = this.newNodes.get(succ);
                if (succBB == nodeBB) continue;
                nodeBB.connectTo(succBB);
            }
        }
    }

    protected boolean isGoToOrStop(U data) {
        return false;
    }
}

