/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobStatusData {
    private static final String JOB_ID_ATTR = "job_id";
    private static final String RM_ID_ATTR = "rm_id";
    private static final String STDOUT_REMOTE_FILE_ATTR = "stdout_remote_path";
    private static final String STDERR_REMOTE_FILE_ATTR = "stderr_remote_path";
    private static final String INTERACTIVE_ATTR = "interactive";
    private static final String STATE_ATTR = "state";
    private static final String STATE_DETAIL_ATTR = "state_detail";
    private static final String OID_ATTR = "oid";
    private static final String QUEUE_NAME_ATTR = "queue_name";
    private static final String OWNER_ATTR = "owner";
    private static final String JOB_OUTERR_READY = "JOB_OUTERR_READY";
    public static final String SUBMITTED = "SUBMITTED";
    public static final String RUNNING = "RUNNING";
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String CANCELED = "CANCELED";
    private final String fRmId;
    private final String fJobId;
    private final String fOutputPath;
    private final String fErrorPath;
    private final String fQueueName;
    private final String fOwner;
    private final boolean fInteractive;
    private String fState = "SUBMITTED";
    private String fStateDetail = "SUBMITTED";
    private boolean fOutReady = false;
    private boolean fErrReady = false;
    private String fOid;
    private boolean fRemoved = false;

    public static List<JobStatusData> reload(IMemento memento) {
        ArrayList<JobStatusData> jobs = new ArrayList<JobStatusData>();
        if (memento != null) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren(JOB_ID_ATTR);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                jobs.add(new JobStatusData(child));
                ++n2;
            }
        }
        return jobs;
    }

    private static boolean detailIsFinal(String detail) {
        return CANCELED.equals(detail) || FAILED.equals(detail) || JOB_OUTERR_READY.equals(detail);
    }

    public JobStatusData(IMemento memento) {
        this.fJobId = memento.getID();
        this.fRmId = memento.getString(RM_ID_ATTR);
        this.fState = memento.getString(STATE_ATTR);
        this.fStateDetail = memento.getString(STATE_DETAIL_ATTR);
        this.fOutputPath = memento.getString(STDOUT_REMOTE_FILE_ATTR);
        this.fErrorPath = memento.getString(STDERR_REMOTE_FILE_ATTR);
        this.fInteractive = memento.getBoolean(INTERACTIVE_ATTR);
        this.fQueueName = memento.getString(QUEUE_NAME_ATTR);
        this.fOwner = memento.getString(OWNER_ATTR);
        this.fOid = memento.getString(OID_ATTR);
        this.fOutReady = this.fOutputPath != null && JOB_OUTERR_READY.equals(this.fStateDetail);
        this.fErrReady = this.fErrorPath != null && JOB_OUTERR_READY.equals(this.fStateDetail);
    }

    public JobStatusData(String rmId, String jobId, String queueName, String owner, String outputPath, String errorPath, boolean interactive) {
        this.fRmId = rmId;
        this.fJobId = jobId;
        this.fQueueName = queueName;
        this.fOwner = owner;
        this.fOutputPath = outputPath;
        this.fErrorPath = errorPath;
        this.fInteractive = interactive;
    }

    public String getErrorPath() {
        return this.fErrorPath;
    }

    public boolean getErrReady() {
        return this.fErrReady;
    }

    public String getJobId() {
        return this.fJobId;
    }

    public String getOid() {
        return this.fOid;
    }

    public String getOutputPath() {
        return this.fOutputPath;
    }

    public boolean getOutReady() {
        return this.fOutReady;
    }

    public String getOwner() {
        return this.fOwner;
    }

    public String getQueueName() {
        return this.fQueueName;
    }

    public String getRmId() {
        return this.fRmId;
    }

    public String getState() {
        return this.fState;
    }

    public String getStateDetail() {
        return this.fStateDetail;
    }

    public boolean isInteractive() {
        return this.fInteractive;
    }

    public boolean isRemoved() {
        return this.fRemoved;
    }

    public boolean isCompleted() {
        return this.fState.equals(COMPLETED);
    }

    public void save(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento jobMemento = memento.createChild(JOB_ID_ATTR, this.fJobId);
        jobMemento.putString(RM_ID_ATTR, this.fRmId);
        jobMemento.putString(STATE_ATTR, this.fState);
        jobMemento.putString(STATE_DETAIL_ATTR, this.fStateDetail);
        jobMemento.putString(STDOUT_REMOTE_FILE_ATTR, this.fOutputPath);
        jobMemento.putString(STDERR_REMOTE_FILE_ATTR, this.fErrorPath);
        jobMemento.putBoolean(INTERACTIVE_ATTR, this.fInteractive);
        jobMemento.putString(QUEUE_NAME_ATTR, this.fQueueName);
        jobMemento.putString(OWNER_ATTR, this.fOwner);
        jobMemento.putString(OID_ATTR, this.fOid);
    }

    public void setErrReady(boolean errReady) {
        this.fErrReady = errReady;
    }

    public void setOid(String oid) {
        this.fOid = oid;
    }

    public void setOutReady(boolean outReady) {
        this.fOutReady = outReady;
    }

    public void setRemoved() {
        this.fRemoved = true;
    }

    public void setState(String state) {
        this.fState = state;
    }

    public void setStateDetail(String stateDetail) {
        this.fStateDetail = stateDetail;
        this.fOutReady = this.fOutputPath != null && JOB_OUTERR_READY.equals(stateDetail);
        this.fErrReady = this.fErrorPath != null && JOB_OUTERR_READY.equals(stateDetail);
    }

    public void updateState(String state, String stateDetail) {
        if (!JobStatusData.detailIsFinal(this.fStateDetail)) {
            this.fState = state;
            this.setStateDetail(stateDetail);
        }
    }
}

